﻿namespace G3dCore.Extensions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using G3dCore.Entities;
    using Opal.Operations;

    /// <summary>
    /// シェーダバリエーションのオペレーション拡張メソッドです。
    /// </summary>
    public static class VariationOperationExtension
    {
        /// <summary>
        /// choice を編集するオペレーションを生成します。
        /// </summary>
        /// <param name="variation">データモデルです。</param>
        /// <param name="value">編集する値です。</param>
        /// <returns>生成したオペレーションを返します。</returns>
        public static Operation CreateEditChoiceOperation(this Variation variation, string value)
        {
            OperationSet operation = new OperationSet();
            operation.Add(new PropertyEditOperation<Variation, string>(variation, "Choice", value));
            return operation;
        }

        /// <summary>
        /// デフォルト値を編集するオペレーションを生成します。
        /// </summary>
        /// <param name="variation">データモデルです。</param>
        /// <param name="value">編集する値です。</param>
        /// <returns>生成したオペレーションを返します。</returns>
        public static Operation CreateEditDefaultOperation(this Variation variation, string value)
        {
            OperationSet operation = new OperationSet();
            operation.Add(new PropertyEditOperation<Variation, string>(variation, "Default", value));
            return operation;
        }

        /// <summary>
        /// 静的分岐を編集するオペレーションを生成します。
        /// </summary>
        /// <param name="variation">データモデルです。</param>
        /// <param name="value">編集する値です。</param>
        /// <returns>生成したオペレーションを返します。</returns>
        public static Operation CreateEditBranchOperation(this Variation variation, bool value)
        {
            OperationSet operation = new OperationSet();
            operation.Add(new PropertyEditOperation<Variation, bool>(variation, "Branch", value));
            return operation;
        }
    }
}
