﻿namespace G3dCore.Extensions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using G3dCore.Entities;

    /// <summary>
    /// シェーダ設定の拡張メソッドです。
    /// </summary>
    public static class ShaderConfigExtension
    {
        /// <summary>
        /// インクルードパスを設定します。
        /// </summary>
        /// <param name="shaderConfig">データモデルです。</param>
        /// <param name="includePaths">インクルードパスです。</param>
        public static void SetIncludePaths(this ShaderConfig shaderConfig, params string[] includePaths)
        {
            shaderConfig.CreateRelpaceIncludePathsOperation(includePaths).Execute();
        }

        /// <summary>
        /// 強制インクルードファイルを設定します。
        /// </summary>
        /// <param name="shaderConfig">データモデルです。</param>
        /// <param name="forceIncludeFiles">強制インクルードファイルです。</param>
        public static void SetForceIncludeFiles(this ShaderConfig shaderConfig, params string[] forceIncludeFiles)
        {
            shaderConfig.CreateRelpaceForceIncludeFilesOperation(forceIncludeFiles).Execute();
        }
    }
}
