﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// データ操作用のインターフェースです。
    /// </summary>
    public interface IEntity : INotifyPropertyChanged, ICloneable
    {
        /// <summary>
        /// エンティティの値が変更されているかどうかを取得します。
        /// </summary>
        bool IsDirty { get; }

        /// <summary>
        /// エンティティがもつ値が変更された場合に自動でCRCを計算するフラグを取得設定します。
        /// </summary>
        bool AutoCalc { get; set; }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        uint HashValue { get; }

        /// <summary>
        /// エンティティの状態をリセットします。
        /// </summary>
        void Reset();

        /// <summary>
        /// エンティティの状態を更新します。
        /// </summary>
        void Refresh();

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        object CreateWriteData();
    }
}
