﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using nw.g3d.nw4f_3dif;
    using Opal.Security.Cryptography;

    /// <summary>
    /// 強制インクルードファイルのエンティティクラスです。
    /// </summary>
    public class ForceIncludeFile : Entity<force_include_fileType>
    {
        private int index = 0;
        private string path = string.Empty;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ForceIncludeFile()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="data">設定するデータです。</param>
        public ForceIncludeFile(force_include_fileType data)
            : this()
        {
            this.index = data.index;
            this.path = data.path ?? string.Empty;
        }

        /// <summary>
        /// インデックスを取得設定します。
        /// </summary>
        public int Index
        {
            get
            {
                return this.index;
            }

            set
            {
                this.SetProperty(ref this.index, value);
            }
        }

        /// <summary>
        /// 強制インクルードファイルのパスを取得設定します。
        /// </summary>
        public string Path
        {
            get
            {
                return this.path;
            }

            set
            {
                this.SetProperty(ref this.path, value ?? string.Empty, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>現在のインスタンスのコピーである新しいオブジェクトを返します。</returns>
        public override IEntity Clone()
        {
            var instance = new ForceIncludeFile();
            instance.index = this.index;
            instance.path = this.path;

            return instance;
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override force_include_fileType CreateWriteData()
        {
            force_include_fileType instance = new force_include_fileType();
            instance.index = this.index;
            instance.path = this.path;

            return instance;
        }

        /// <summary>
        /// エンティティのCRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRCの値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            Debug.Assert(this.path != null);

            // Index プロパティは、出力時に計算しなおすので、CRCの計算対象外
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.path)));

            var hashValue = crc.ComputeHashUInt32(buffers.ToArray());
            return hashValue;
        }
    }
}
