﻿namespace G3dCore.Entities
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using nw.g3d.nw4f_3dif;

    /// <summary>
    /// 中間ファイルの生成情報のエンティティクラスです。
    /// </summary>
    public class Create : ObservableEntity<createType>
    {
        private string toolName = string.Empty;
        private string toolVersion = string.Empty;
        private string srcPath = string.Empty;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public Create()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="data">設定するデータです。</param>
        public Create(createType data)
        {
            this.toolName = data.tool_name;
            this.toolVersion = data.tool_version;
            this.srcPath = data.src_path;
        }

        /// <summary>
        /// 中間ファイルを作成したツールの名前を取得設定します。
        /// </summary>
        public string ToolName
        {
            get
            {
                return this.toolName;
            }

            set
            {
                this.SetProperty(ref this.toolName, value);
            }
        }

        /// <summary>
        /// 中間ファイルを作成したツールのバージョンを取得設定します。
        /// </summary>
        public string ToolVersion
        {
            get
            {
                return this.toolVersion;
            }

            set
            {
                this.SetProperty(ref this.toolVersion, value);
            }
        }

        /// <summary>
        /// 中間ファイルを作成した際に、元ファイルがあった場合のフルパスを取得設定します。
        /// </summary>
        public string SrcPath
        {
            get
            {
                return this.srcPath;
            }

            set
            {
                this.SetProperty(ref this.srcPath, value);
            }
        }

        /// <summary>
        /// 現在のインスタンスのコピーである新しいオブジェクトを作成します。
        /// </summary>
        /// <returns>現在のインスタンスのコピーである新しいオブジェクトを返します。</returns>
        public override IEntity Clone()
        {
            var instance = new Create();
            instance.toolName = this.toolName;
            instance.toolVersion = this.toolVersion;
            instance.srcPath = this.srcPath;

            return instance;
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override createType CreateWriteData()
        {
            var instance = new createType();
            instance.tool_name = this.toolName;
            instance.tool_version = this.toolVersion;
            instance.src_path = this.srcPath;

            return instance;
        }

        /// <summary>
        /// エンティティのCRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRCの値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            return 0;
        }
    }
}
