﻿namespace ShaderAssistAddons.Modules.ShaderConfig.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Data;
    using System.Windows.Documents;
    using System.Windows.Input;
    using System.Windows.Media;
    using System.Windows.Media.Imaging;
    using System.Windows.Navigation;
    using System.Windows.Shapes;
    using ShaderAssistAddons.Modules.ShaderConfig.ViewModels;

    /// <summary>
    /// ShaderSourceSettingControl.xaml の相互作用ロジック
    /// </summary>
    public partial class ShaderSourceSettingControl : UserControl
    {
        public ShaderSourceSettingControl()
        {
            InitializeComponent();
        }

        private void ShaderSourceTextBox_PreviewDragOver(object sender, DragEventArgs e)
        {
            if (e.Data.GetData(DataFormats.FileDrop) != null)
            {
                e.Effects = DragDropEffects.Copy;
            }
            else
            {
                e.Effects = DragDropEffects.None;
            }

            e.Handled = true;
        }

        private void ShaderSourceTextBox_Drop(object sender, DragEventArgs e)
        {
            string[] files = e.Data.GetData(DataFormats.FileDrop) as string[];
            if (files != null && files.Length > 0)
            {
                ShaderSourceSettingViewModel vm = (ShaderSourceSettingViewModel)this.DataContext;
                vm.AddPath(files[0]);

                // CanExecute を即時反映させるために必要。
                ShaderSourceTextBox.Focus();
            }
        }
    }
}
