﻿namespace ShaderAssistAddons.Menus
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using G3dCore.Messaging;
    using G3dCore.Resources;
    using G3dCore.Storages;
    using G3dCore.Windows.Utilities;
    using Opal.App;
    using Opal.Menus;
    using Opal.Plugins;
    using ShaderAssistAddons.Modules.ShaderConfig.Actions;
    using ShaderAssistAddons.Modules.ShaderConfig.ViewModels;

    /// <summary>
    /// 新規シェーダ設定メニュークラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public class NewShaderConfigMenu : CommandableMenuPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public NewShaderConfigMenu()
            : base("NewShaderConfig", Labels.MenuShaderConfig, 2)
        {
            this.SetCommand(param => this.DoCommand(param), param => { return this.CanDoCommand(param); });
        }

        /// <summary>
        /// メニュー内のどの種類かを取得します。
        /// </summary>
        public override MenuCategory Category
        {
            get
            {
                return MenuCategory.FileNew;
            }
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        private void DoCommand(object parameter)
        {
            var wizardAction = new WizardAction();
            var manualTrigger = new ManualTrigger();
            manualTrigger.Actions.Add(wizardAction);

            var wizardViewModel = new WizardShaderConfigViewModel(null);

            var input = new WizardAction.InputArg()
            {
                WizardViewModel = wizardViewModel
            };

            var eventArgs = new MessageEventArgs(
                new Message(input),
                m =>
                {
                    var output = (WizardAction.OutputArg)m.Response;
                    if (output.Result == true)
                    {
                        var weakStorage = AppManager.GetStorage<G3dStorage>();
                        Debug.Assert(weakStorage != null);

                        G3dStorage storage = null;
                        if (weakStorage.TryGetTarget(out storage))
                        {
                            storage.AddG3dFile(wizardViewModel.CreateNewShaderConfig());
                        }
                    }
                });

            manualTrigger.Invoke(eventArgs);
        }

        /// <summary>
        /// コマンドが実行可能か判定します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        /// <returns>実行可能な場合は、true を返します。</returns>
        private bool CanDoCommand(object parameter)
        {
            return true;
        }
    }
}
