﻿namespace G3dAddons.Menus
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.App;
    using Opal.Logs;
    using Opal.Menus;
    using Opal.Plugins;

    /// <summary>
    /// モック用の新規作成メニューです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public sealed class MockMenu : CommandableMenuPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public MockMenu()
            : base("Mock", "Mock", 0)
        {
            this.SetCommand(param => this.DoCommand(param), param => { return this.CanDoCommand(param); });
        }

        /// <summary>
        /// メニュー内のどの種類かを取得します。
        /// </summary>
        public override MenuCategory Category
        {
            get
            {
                 return MenuCategory.FileNew;
            }
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        private void DoCommand(object parameter)
        {
            var logManager = AppManager.GetLogManager();
            Debug.Assert(logManager != null);

            var document = AppManager.CreateDocument("G3d", "Mock");
            document.Title = "モック";
            document.Setup(null);
            AppManager.AddDocument(document);

            var logger = new Logger();
            logger.Debug("Mock");
            logManager.PushLogger(logger);
            logManager.FlushAll();
        }

        /// <summary>
        /// コマンドが実行可能か判定します。
        /// </summary>
        /// <param name="parameter">コマンドのパラメータです。</param>
        /// <returns>実行可能な場合は、true を返します。</returns>
        private bool CanDoCommand(object parameter)
        {
            return true;
        }
    }
}
