﻿namespace G3dAddons.Documents
{
    using System.ComponentModel.Composition;
    using System.Windows.Controls;
    using G3dAddons.Modules.Mock;
    using Opal.Plugins;
    using Opal.ViewModels;
    using Opal.Windows.Documents;

    /// <summary>
    /// モックドキュメント作成クラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public class MockDocumentMaker : DocumentMakerPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public MockDocumentMaker()
            : base("Mock")
        {
        }

        /// <summary>
        /// ビューを生成します。
        /// </summary>
        /// <returns>ビューのインスタンスを返します。</returns>
        public override Control CreateView()
        {
            return new MockView();
        }

        /// <summary>
        /// ビューに対応するビューモデルを生成します。
        /// </summary>
        /// <returns>ビューモデルのインスタンスを返します。</returns>
        public override DocumentViewModel CreateViewModel()
        {
            var viewModel = new MockViewModel();
            viewModel.Title = "Mock";
            return viewModel;
        }
    }
}
