﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Reflection;
using System.Xml;
using System.Xml.Serialization;
using System.Linq;
using ConfigCommon;

namespace UserConfig
{
    [Serializable]
    public class UserSetting
    {
        [XmlAttribute]
        public string Version { get; set; }

        [XmlElement("SearchPath")]
        public List<TeamConfig.FileIo.SearchPath> SearchPaths;

        [XmlElement("StartUpPath")]
        public List<StartUp> StartUpPaths;

        public ReloadOptions ReloadOptions;

        public EditHistory EditHistory;

        public ExternalProgram ExternalProgram { get; set; }

        public IO IO { get; set; }

        public UI UI { get; set; }
        public UserSetting()
        {
            StartUpPaths = new List<StartUp>();
            Version = ConfigCommon.Common.Version;
            SearchPaths = new List<TeamConfig.FileIo.SearchPath>();
            ReloadOptions = new ReloadOptions();
            EditHistory = new EditHistory();
            ExternalProgram = new ExternalProgram();
            IO = new IO();
            UI = new UI();
        }
    }
}
