﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace ConfigCommon
{
    public enum HioTarget
    {
        Device,
        Pc,
        //[Obsolete] 指定すると古いバージョンのファイルが読めなくなるので指定しない
        Cafe = Device,		// 使わない
        CatDev = Device,    // 使わない
    };

    public enum ValueMode : int
    {
        Uchar,
        Float
    };

    public enum ColorMode : int
    {
        RGBA,
        RGB,
        LinearRgba,
        LinearRgb,
        HSVA,
        HSV,
        A
    };

    public enum MipmapOrientationType
    {
        Horizontal,
        Vertical
    };

    /// <summary>
    /// ＧＵＩオブジェクトＩＤ。
    /// </summary>
    public enum GuiObjectID
    {
        // GuiObjectID を更新したら、ObjectIDUtility も更新する必要がある。

        Model,
        Material,
        Bone,
        Shape,
        AnimationSet,
        //
        Texture,
        //
        ShaderDefinition,
        //
        Definition,
        //
        Project,

        // アニメーションIDを変更したらGuiObject.isAnimationHashSet_を修正する
        SkeletalAnimation,
        ShapeAnimation,
        ShaderParameterAnimation,
        ColorAnimation,
        TextureSrtAnimation,
        MaterialVisibilityAnimation,
        BoneVisibilityAnimation,
        TexturePatternAnimation,
        SceneAnimation,
        CameraAnimation,
        LightAnimation,
        FogAnimation,
        MaterialAnimation,

        SeparateMaterial,

        DummyObject,
    }

    public enum PasteMethodType
    {
        Insert,
        Displacement,
        Merge
    };

    public enum PastePositionType
    {
        Relative,
        Absolute
    };
}
