﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using ConfigCommon;

namespace AppConfig
{
    [XmlType("AppConfig.Preview")]
    public class Preview
    {
        [XmlAttribute]	public bool				IsPreviewCameraFocus{ get; set; }
        [XmlAttribute]	public bool				IsAutoConnection{ get; set; }
        [XmlAttribute]
        public bool OptimizeShader { get; set; }

        [XmlAttribute]	public HioTarget	Target
        {
            get
            {
                return target_;
            }

            set
            {
                target_ = value;
            }
        }

        public List<TargetForPlatform> TargetForPlatforms { get; set; }
        private HioTarget	target_;

        public Preview()
        {
            // 初期値
            IsPreviewCameraFocus	= true;
            IsAutoConnection		= false;
            Target					= HioTarget.Pc;
            OptimizeShader = false;
            TargetForPlatforms = new List<TargetForPlatform>();
        }

        public class TargetForPlatform
        {
            [XmlAttribute]
            public string Platform;

            [XmlAttribute]
            public string Target;
        }
    }
}
