﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using ConfigCommon;

namespace AppConfig
{
    public class ColorPicker
    {
                        public Point?		Location{		get; set; }

        // float[3]
        [XmlIgnore]		public float[][]		CustomColor{	get; set; }
        [XmlAttribute]	public ColorMode	ColorMode{		get; set; }
        [XmlAttribute]	public ValueMode	ValueMode{		get; set; }

        public const int CustomColorCount = 16;

        // シリアライズ用
        public string CustomColor0{ get { return TranslateToString(CustomColor[0x0]); } set { CustomColor[0x0] = TranslateFromString(value); } }
        public string CustomColor1{ get { return TranslateToString(CustomColor[0x1]); } set { CustomColor[0x1] = TranslateFromString(value); } }
        public string CustomColor2{ get { return TranslateToString(CustomColor[0x2]); } set { CustomColor[0x2] = TranslateFromString(value); } }
        public string CustomColor3{ get { return TranslateToString(CustomColor[0x3]); } set { CustomColor[0x3] = TranslateFromString(value); } }
        public string CustomColor4{ get { return TranslateToString(CustomColor[0x4]); } set { CustomColor[0x4] = TranslateFromString(value); } }
        public string CustomColor5{ get { return TranslateToString(CustomColor[0x5]); } set { CustomColor[0x5] = TranslateFromString(value); } }
        public string CustomColor6{ get { return TranslateToString(CustomColor[0x6]); } set { CustomColor[0x6] = TranslateFromString(value); } }
        public string CustomColor7{ get { return TranslateToString(CustomColor[0x7]); } set { CustomColor[0x7] = TranslateFromString(value); } }
        public string CustomColor8{ get { return TranslateToString(CustomColor[0x8]); } set { CustomColor[0x8] = TranslateFromString(value); } }
        public string CustomColor9{ get { return TranslateToString(CustomColor[0x9]); } set { CustomColor[0x9] = TranslateFromString(value); } }
        public string CustomColorA{ get { return TranslateToString(CustomColor[0xA]); } set { CustomColor[0xA] = TranslateFromString(value); } }
        public string CustomColorB{ get { return TranslateToString(CustomColor[0xB]); } set { CustomColor[0xB] = TranslateFromString(value); } }
        public string CustomColorC{ get { return TranslateToString(CustomColor[0xC]); } set { CustomColor[0xC] = TranslateFromString(value); } }
        public string CustomColorD{ get { return TranslateToString(CustomColor[0xD]); } set { CustomColor[0xD] = TranslateFromString(value); } }
        public string CustomColorE{ get { return TranslateToString(CustomColor[0xE]); } set { CustomColor[0xE] = TranslateFromString(value); } }
        public string CustomColorF{ get { return TranslateToString(CustomColor[0xF]); } set { CustomColor[0xF] = TranslateFromString(value); } }

        public ColorPicker()
        {
            // 初期値
            Location = null;

            CustomColor = new float[CustomColorCount][]
            {
                new [] {1.0f, 1.0f, 1.0f },
                new [] {1.0f, 0.0f, 0.0f },
                new [] {1.0f, 1.0f, 0.0f },
                new [] {0.0f, 1.0f, 0.0f },
                new [] {0.0f, 1.0f, 1.0f },
                new [] {0.0f, 0.0f, 1.0f },
                new [] {1.0f, 0.0f, 1.0f },
                new [] {0.0f, 0.0f, 0.0f },
                new [] {0.5f, 0.5f, 0.5f },
                new [] {0.5f, 0.0f, 0.0f },
                new [] {0.5f, 0.5f, 0.0f },
                new [] {0.0f, 0.5f, 0.0f },
                new [] {0.0f, 0.5f, 0.5f },
                new [] {0.0f, 0.0f, 0.5f },
                new [] {0.5f, 0.0f, 0.5f },
                new [] {0.0f, 0.0f, 0.0f },
            };

            ColorMode = ColorMode.RGBA;
            ValueMode = ValueMode.Float;
        }

        private static float[] TranslateFromString(string v)
        {
            // 互換性のために # から始まるhtml 形式も認める
            if (v.StartsWith("#"))
            {
                var color = ColorTranslator.FromHtml(v);
                return new float[3] { color.R/255.0f, color.G/255.0f, color.B/255.0f };
            }

            return nw.g3d.nw4f_3dif.G3dDataParser.ParseFloatArray(v);
        }

        private static string TranslateToString(float[] v)
        {
            var builder = new StringBuilder();
            foreach (var e in v)
            {
                nw.g3d.nw4f_3dif.G3dDataFormatter.AppendFloat(builder, e);
            }
            return builder.ToString();
        }
    }
}
