﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Bridge.res;
using Nintendo.Foundation.IO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Bridge
{
    class SubCommandBase
    {
        static public string DescriptionConverter(string description, string name)
        {
            return Help.ResourceManager.GetString(description.Replace('-', '_'), Help.Culture);
        }

        [CommandLineArgFileOption("args-file", Description = "args-file", DescriptionConverterName = "DescriptionConverter")]
        public string ArgsFile { get; set; }
    }

    class CommandLineParameters : SubCommandBase
    {
        [CommandLineSubCommand("start-3deditor", Description = "start-3deditor", DescriptionConverterName = "DescriptionConverter")]
        public Start3DEditor Start3DEditor { get; set; }

        [CommandLineSubCommand("close-3deditor", Description = "close-3deditor", DescriptionConverterName = "DescriptionConverter")]
        public object Close3DEditor { get; set; }

        [CommandLineSubCommand("export-info", Description = "export-info", DescriptionConverterName = "DescriptionConverter")]
        public ExportInfo ExportInfo { get; set; }

        [CommandLineSubCommand("export-temporary-files", Description = "export-temporary-files", DescriptionConverterName = "DescriptionConverter")]
        public ExportTemporaryFiles ExportTemporaryFiles { get; set; }

        [CommandLineSubCommand("reload-temporary-files", Description = "reload-temporary-files", DescriptionConverterName = "DescriptionConverter")]
        public ReloadTemporaryFiles ReloadTemporaryFiles { get; set; }

        [CommandLineSubCommand("load-files", Description = "load-files", DescriptionConverterName = "DescriptionConverter")]
        public LoadFiles LoadFiles { get; set; }

        [CommandLineSubCommand("save-files", Description = "save-files", DescriptionConverterName = "DescriptionConverter")]
        public SaveFiles SaveFiles { get; set; }

        [CommandLineSubCommand("save-all", Description = "save-all", DescriptionConverterName = "DescriptionConverter")]
        public SaveAll SaveAll { get; set; }

        [CommandLineSubCommand("close-all", Description = "close-all", DescriptionConverterName = "DescriptionConverter")]
        public object CloseAll { get; set; }

        [CommandLineSubCommand("connect-runtime", Description = "connect-runtime", DescriptionConverterName = "DescriptionConverter")]
        public ConnectRuntime ConnectRuntime { get; set; }

        [CommandLineSubCommand("disconnect-runtime", Description = "disconnect-runtime", DescriptionConverterName = "DescriptionConverter")]
        public object DisconnectRuntime { get; set; }

        [CommandLineSubCommand("clear-history", Description = "clear-history", DescriptionConverterName = "DescriptionConverter")]
        public object ClearHistory { get; set; }

        [CommandLineSubCommand("optimize-shader", Description = "optimize-shader", DescriptionConverterName = "DescriptionConverter")]
        public OptimizeShader OptimizeShader { get; set; }

        [CommandLineSubCommand("query-connection-state", Description = "query-connection-state", DescriptionConverterName = "DescriptionConverter")]
        public object QueryConnectionState { get; set; }
    }

    class ExportInfo : SubCommandBase
    {
        [CommandLineOption("output", Description = "output", IsRequired = true, ValueName = "file-path", DescriptionConverterName = "DescriptionConverter")]
        public string OutputPath { get; set; }
    }

    class ExportTemporaryFiles : SubCommandBase
    {
        [CommandLineOption("path", Description = "path-Output", IsRequired = true, ValueName = "directory-path", DescriptionConverterName = "DescriptionConverter")]
        public string Path { get; set; }

        [CommandLineValues(CountMin = 1, Description = "file-names-output", ValueName = "file-names", DescriptionConverterName = "DescriptionConverter")]
        public string[] FileNames { get; set; }
    }

    class ReloadTemporaryFiles : SubCommandBase
    {
        [CommandLineOption("force-unload-and-load", Description = "force-unload-and-load", DescriptionConverterName = "DescriptionConverter")]
        public bool ForceUnloadAndLoad { get; set; }

        [CommandLineOption("path", Description = "path-Reload", IsRequired = true, ValueName = "directory-path", DescriptionConverterName = "DescriptionConverter")]
        public string Path { get; set; }

        [CommandLineValues(CountMin = 1, Description = "file-names-reload", ValueName = "file-names", DescriptionConverterName = "DescriptionConverter")]
        public string[] FileNames { get; set; }
    }

    class LoadFiles : SubCommandBase
    {
        [CommandLineValues(CountMin = 1, Description = "file-paths-load", ValueName = "file-paths", DescriptionConverterName = "DescriptionConverter")]
        public string[] Paths { get; set; }
    }

    class SaveFiles : SubCommandBase
    {
        [CommandLineOption("disable-file-info", Description = "disable-file-info", IsRequired = false, DescriptionConverterName = "DescriptionConverter")]
        public bool DisableFileInfo { get; set; }

        [CommandLineValues(CountMin = 1, Description = "file-paths-save", ValueName = "file-paths", DescriptionConverterName = "DescriptionConverter")]
        public string[] Paths { get; set; }
    }

    class SaveAll : SubCommandBase
    {
        [CommandLineOption("disable-file-info", Description = "disable-file-info", IsRequired = false, DescriptionConverterName = "DescriptionConverter")]
        public bool DisableFileInfo { get; set; }
    }

    class ConnectRuntime : SubCommandBase
    {
        [CommandLineOption("target", Description = "target", IsRequired = true, DescriptionConverterName = "DescriptionConverter")]
        public string Target { get; set; }

        [CommandLineOption("platform", Description = "platform", IsRequired = false, DescriptionConverterName = "DescriptionConverter")]
        public string Platform { get; set; }
    }

    class Start3DEditor : SubCommandBase
    {
        [CommandLineOption("team-settings-file", Description = "team-settings-file", IsRequired = false, ValueName = "team-settings-file-path", DescriptionConverterName = "DescriptionConverter")]
        public string TeamSettingsFilePath { get; set; }
    }

    class OptimizeShader : SubCommandBase
    {
        [CommandLineOption("disable", Description = "disable-optimize-shader", IsRequired = false, DescriptionConverterName = "DescriptionConverter")]
        public bool Disable { get; set; }
    }
}
