﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Reflection;
using System.Windows.Forms;

namespace App
{
    class VersionInformation
    {
        // 名前
        public static string Name { get { return Application.ProductName; } }

        // バージョン
        public static string Version { get { return Application.ProductVersion; } }

        // Subversion のリビジョン
        public static string SvnRevision
        {
            get
            {
                Assembly entry = Assembly.GetEntryAssembly();
                FileVersionInfo fileVersionInfo = FileVersionInfo.GetVersionInfo(entry.Location);
                string[] versions = fileVersionInfo.FileVersion.Split('.');
                Debug.Assert(versions.Length == 4);
                return versions[3];
            }
        }

        // ビルド日時
        public static DateTime BuildDate
        {
            get
            {
                Assembly entry = Assembly.GetEntryAssembly();
                Version version = entry.GetName().Version;
                DateTime buildDate = new DateTime(2000, 1, 1, 0, 0, 0);
                buildDate = buildDate.AddDays((double)version.Build);
                buildDate = buildDate.AddSeconds((double)version.Revision * 2.0);
                return buildDate;
            }
        }
    }
}
