﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using App.PropertyEdit;
using App.res;
using ConfigCommon;
using nw.g3d.nw4f_3dif;
using System.Diagnostics;
using System.Windows.Forms;
namespace App.Data
{
    /// <summary>
    /// ＵＩテキストクラス。
    /// </summary>
    public static partial class UIText
    {
        #region GuiObjectID
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(GuiObjectID value)
        {
            switch(value)
            {
                case GuiObjectID.Model:							return Strings.Enum_GuiObjectID_Model;
                case GuiObjectID.Material:						return Strings.Enum_GuiObjectID_Material;
                case GuiObjectID.Bone:							return Strings.Enum_GuiObjectID_Bone;
                case GuiObjectID.Shape:							return Strings.Enum_GuiObjectID_Shape;
                case GuiObjectID.AnimationSet:					return Strings.Enum_GuiObjectID_AnimationSet;
                case GuiObjectID.Texture:						return Strings.Enum_GuiObjectID_Texture;
                case GuiObjectID.ShaderDefinition:				return Strings.Enum_GuiObjectID_ShaderDefinition;
                case GuiObjectID.Definition:
                    {
                        // 使われることはないはず
                        // TODO: 削除
                        Debug.Assert(false);
                        return Strings.Enum_GuiObjectID_ShaderProgram;
                    }
                case GuiObjectID.Project:						return Strings.Enum_GuiObjectID_Project;
                case GuiObjectID.SkeletalAnimation:				return Strings.Enum_GuiObjectID_SkeletalAnimation;
                case GuiObjectID.ShapeAnimation:				return Strings.Enum_GuiObjectID_ShapeAnimation;
                case GuiObjectID.MaterialAnimation:             return Strings.Enum_GuiObjectID_MaterialAnimation;
                case GuiObjectID.ShaderParameterAnimation:		return Strings.Enum_GuiObjectID_ShaderParameterAnimation;
                case GuiObjectID.ColorAnimation:				return Strings.Enum_GuiObjectID_ColorAnimation;
                case GuiObjectID.TextureSrtAnimation:			return Strings.Enum_GuiObjectID_TextureSrtAnimation;
                case GuiObjectID.MaterialVisibilityAnimation:	return Strings.Enum_GuiObjectID_MaterialVisibilityAnimation;
                case GuiObjectID.BoneVisibilityAnimation:		return Strings.Enum_GuiObjectID_BoneVisibilityAnimation;
                case GuiObjectID.TexturePatternAnimation:		return Strings.Enum_GuiObjectID_TexturePatternAnimation;
                case GuiObjectID.SceneAnimation:				return Strings.Enum_GuiObjectID_SceneAnimation;
                case GuiObjectID.CameraAnimation:				return Strings.Enum_GuiObjectID_CameraAnimation;
                case GuiObjectID.LightAnimation:				return Strings.Enum_GuiObjectID_LightAnimation;
                case GuiObjectID.FogAnimation:					return Strings.Enum_GuiObjectID_FogAnimation;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region skeleton_info_scale_modeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(skeleton_info_scale_modeType value)
        {
            switch(value)
            {
                case skeleton_info_scale_modeType.standard:		return Strings.Enum_skeleton_info_scale_modeType_standard;
                case skeleton_info_scale_modeType.maya:			return Strings.Enum_skeleton_info_scale_modeType_maya;
                case skeleton_info_scale_modeType.softimage:	return Strings.Enum_skeleton_info_scale_modeType_softimage;
            }

            throw new NotImplementedException();
        }

        #endregion

        #region skeleton_info_rotate_modeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(skeleton_info_rotate_modeType value)
        {
            switch(value)
            {
                case skeleton_info_rotate_modeType.euler_xyz:	return Strings.Enum_skeleton_info_rotate_modeType_euler_xyz;
                case skeleton_info_rotate_modeType.quaternion:	return Strings.Enum_skeleton_info_rotate_modeType_quaternion;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region skeleton_info_scale_modeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(bone_billboardType value)
        {
            switch (value)
            {
                case bone_billboardType.none: return Strings.Enum_bone_billboardType_none;
                case bone_billboardType.world_viewvector: return Strings.Enum_bone_billboardType_world;
                case bone_billboardType.world_viewpoint: return Strings.Enum_bone_billboardType_world_viewpoint;
                case bone_billboardType.screen_viewvector: return Strings.Enum_bone_billboardType_screen;
                case bone_billboardType.screen_viewpoint: return Strings.Enum_bone_billboardType_screen_viewpoint;
                case bone_billboardType.yaxis_viewvector: return Strings.Enum_bone_billboardType_yaxis;
                case bone_billboardType.yaxis_viewpoint: return Strings.Enum_bone_billboardType_yaxis_viewpoint;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region skeletal_anim_info_scale_modeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(skeletal_anim_info_scale_modeType value)
        {
            switch (value)
            {
                case skeletal_anim_info_scale_modeType.standard: return Strings.Enum_skeletal_anim_info_scale_modeType_standard;
                case skeletal_anim_info_scale_modeType.maya: return Strings.Enum_skeletal_anim_info_scale_modeType_maya;
                case skeletal_anim_info_scale_modeType.softimage: return Strings.Enum_skeletal_anim_info_scale_modeType_softimage;
            }

            throw new NotImplementedException();
        }

        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValueSimple(skeletal_anim_info_scale_modeType value)
        {
            switch (value)
            {
                case skeletal_anim_info_scale_modeType.standard: return Strings.Enum_skeletal_anim_info_scale_modeType_standard_Simple;
                case skeletal_anim_info_scale_modeType.maya: return Strings.Enum_skeletal_anim_info_scale_modeType_maya_Simple;
                case skeletal_anim_info_scale_modeType.softimage: return Strings.Enum_skeletal_anim_info_scale_modeType_softimage_Simple;
            }

            throw new NotImplementedException();
        }

        #endregion

        #region skeletal_anim_info_rotate_modeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(skeletal_anim_info_rotate_modeType value)
        {
            switch (value)
            {
                case skeletal_anim_info_rotate_modeType.euler_xyz: return Strings.Enum_skeletal_anim_info_rotate_modeType_euler_xyz;
                case skeletal_anim_info_rotate_modeType.quaternion: return Strings.Enum_skeletal_anim_info_rotate_modeType_quaternion;
            }

            throw new NotImplementedException();
        }

        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValueSimple(skeletal_anim_info_rotate_modeType value)
        {
            switch (value)
            {
                case skeletal_anim_info_rotate_modeType.euler_xyz: return Strings.Enum_skeletal_anim_info_rotate_modeType_euler_xyz_Simple;
                case skeletal_anim_info_rotate_modeType.quaternion: return Strings.Enum_skeletal_anim_info_rotate_modeType_quaternion_Simple;
            }

            throw new NotImplementedException();
        }

        #endregion

        #region mesh_modeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(mesh_modeType value)
        {
            switch (value)
            {
                case mesh_modeType.triangles: return Strings.Enum_mesh_modeType_triangles;
                case mesh_modeType.triangle_fan: return Strings.Enum_mesh_modeType_triangle_fan;
                case mesh_modeType.triangle_strip: return Strings.Enum_mesh_modeType_triangle_strip;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region mesh_quantize_typeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(mesh_quantize_typeType value)
        {
            switch (value)
            {
                case mesh_quantize_typeType.none: return Strings.Enum_mesh_quantize_typeType_none;
                case mesh_quantize_typeType.uint_16: return Strings.Enum_mesh_quantize_typeType_uint_16;
                case mesh_quantize_typeType.uint_32: return Strings.Enum_mesh_quantize_typeType_uint_32;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region wrap_uvwType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(wrap_uvwType value)
        {
            switch(value)
            {
                case wrap_uvwType.repeat:		return Strings.Enum_wrap_uvwType_repeat;
                case wrap_uvwType.mirror:		return Strings.Enum_wrap_uvwType_mirror;
                case wrap_uvwType.clamp:		return Strings.Enum_wrap_uvwType_clamp;
                case wrap_uvwType.mirror_once:	return Strings.Enum_wrap_uvwType_mirror_once;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region filter_mag_minType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(filter_mag_minType value)
        {
            switch(value)
            {
                case filter_mag_minType.point:	return Strings.Enum_filter_mag_minType_point;
                case filter_mag_minType.linear:	return Strings.Enum_filter_mag_minType_linear;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region filter_mipType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(filter_mipType value)
        {
            switch(value)
            {
                case filter_mipType.none:	return Strings.Enum_filter_mipType_none;
                case filter_mipType.point:	return Strings.Enum_filter_mipType_point;
                case filter_mipType.linear:	return Strings.Enum_filter_mipType_linear;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region filter_max_anisoType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(filter_max_anisoType value)
        {
            switch(value)
            {
                case filter_max_anisoType.aniso_1:	return Strings.Enum_filter_max_anisoType_aniso_1;
                case filter_max_anisoType.aniso_2:	return Strings.Enum_filter_max_anisoType_aniso_2;
                case filter_max_anisoType.aniso_4:	return Strings.Enum_filter_max_anisoType_aniso_4;
                case filter_max_anisoType.aniso_8:	return Strings.Enum_filter_max_anisoType_aniso_8;
                case filter_max_anisoType.aniso_16:	return Strings.Enum_filter_max_anisoType_aniso_16;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region filter_max_anisoType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(texture_info_dimensionType value)
        {
            switch(value)
            {
                case texture_info_dimensionType.Item1d:			return Strings.Enum_texture_info_dimensionType_Item1d;
                case texture_info_dimensionType.Item2d:			return Strings.Enum_texture_info_dimensionType_Item2d;
                case texture_info_dimensionType.Item3d:			return Strings.Enum_texture_info_dimensionType_Item3d;
                case texture_info_dimensionType.cube:			return Strings.Enum_texture_info_dimensionType_cube;
                case texture_info_dimensionType.Item1d_array:	return Strings.Enum_texture_info_dimensionType_Item1d_array;
                case texture_info_dimensionType.Item2d_array:	return Strings.Enum_texture_info_dimensionType_Item2d_array;
                case texture_info_dimensionType.cube_array:		return Strings.Enum_texture_info_dimensionType_cube_array;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region filter_max_anisoType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(texture_info_quantize_typeType value)
        {
            switch(value)
            {
                case texture_info_quantize_typeType.unorm_8:				return Strings.Enum_texture_info_quantize_typeType_unorm_8;
                case texture_info_quantize_typeType.uint_8:					return Strings.Enum_texture_info_quantize_typeType_uint_8;
                case texture_info_quantize_typeType.snorm_8:				return Strings.Enum_texture_info_quantize_typeType_snorm_8;
                case texture_info_quantize_typeType.sint_8:					return Strings.Enum_texture_info_quantize_typeType_sint_8;
                case texture_info_quantize_typeType.unorm_4_4:				return Strings.Enum_texture_info_quantize_typeType_unorm_4_4;
                case texture_info_quantize_typeType.unorm_16:				return Strings.Enum_texture_info_quantize_typeType_unorm_16;
                case texture_info_quantize_typeType.uint_16:				return Strings.Enum_texture_info_quantize_typeType_uint_16;
                case texture_info_quantize_typeType.snorm_16:				return Strings.Enum_texture_info_quantize_typeType_snorm_16;
                case texture_info_quantize_typeType.sint_16:				return Strings.Enum_texture_info_quantize_typeType_sint_16;
                case texture_info_quantize_typeType.float_16:				return Strings.Enum_texture_info_quantize_typeType_float_16;
                case texture_info_quantize_typeType.unorm_8_8:				return Strings.Enum_texture_info_quantize_typeType_unorm_8_8;
                case texture_info_quantize_typeType.uint_8_8:				return Strings.Enum_texture_info_quantize_typeType_uint_8_8;
                case texture_info_quantize_typeType.snorm_8_8:				return Strings.Enum_texture_info_quantize_typeType_snorm_8_8;
                case texture_info_quantize_typeType.sint_8_8:				return Strings.Enum_texture_info_quantize_typeType_sint_8_8;
                case texture_info_quantize_typeType.unorm_5_6_5:			return Strings.Enum_texture_info_quantize_typeType_unorm_5_6_5;
                case texture_info_quantize_typeType.unorm_5_5_5_1:			return Strings.Enum_texture_info_quantize_typeType_unorm_5_5_5_1;
                case texture_info_quantize_typeType.unorm_4_4_4_4:			return Strings.Enum_texture_info_quantize_typeType_unorm_4_4_4_4;
                case texture_info_quantize_typeType.unorm_1_5_5_5:			return Strings.Enum_texture_info_quantize_typeType_unorm_1_5_5_5;
                case texture_info_quantize_typeType.uint_32:				return Strings.Enum_texture_info_quantize_typeType_uint_32;
                case texture_info_quantize_typeType.sint_32:				return Strings.Enum_texture_info_quantize_typeType_sint_32;
                case texture_info_quantize_typeType.float_32:				return Strings.Enum_texture_info_quantize_typeType_float_32;
                case texture_info_quantize_typeType.unorm_16_16:			return Strings.Enum_texture_info_quantize_typeType_unorm_16_16;
                case texture_info_quantize_typeType.uint_16_16:				return Strings.Enum_texture_info_quantize_typeType_uint_16_16;
                case texture_info_quantize_typeType.snorm_16_16:			return Strings.Enum_texture_info_quantize_typeType_snorm_16_16;
                case texture_info_quantize_typeType.sint_16_16:				return Strings.Enum_texture_info_quantize_typeType_sint_16_16;
                case texture_info_quantize_typeType.float_16_16:			return Strings.Enum_texture_info_quantize_typeType_float_16_16;
                case texture_info_quantize_typeType.float_11_11_10:			return Strings.Enum_texture_info_quantize_typeType_float_11_11_10;
                case texture_info_quantize_typeType.unorm_10_10_10_2:		return Strings.Enum_texture_info_quantize_typeType_unorm_10_10_10_2;
                case texture_info_quantize_typeType.uint_10_10_10_2:		return Strings.Enum_texture_info_quantize_typeType_uint_10_10_10_2;
                case texture_info_quantize_typeType.unorm_8_8_8_8:			return Strings.Enum_texture_info_quantize_typeType_unorm_8_8_8_8;
                case texture_info_quantize_typeType.uint_8_8_8_8:			return Strings.Enum_texture_info_quantize_typeType_uint_8_8_8_8;
                case texture_info_quantize_typeType.snorm_8_8_8_8:			return Strings.Enum_texture_info_quantize_typeType_snorm_8_8_8_8;
                case texture_info_quantize_typeType.sint_8_8_8_8:			return Strings.Enum_texture_info_quantize_typeType_sint_8_8_8_8;
                case texture_info_quantize_typeType.srgb_8_8_8_8:			return Strings.Enum_texture_info_quantize_typeType_srgb_8_8_8_8;
                case texture_info_quantize_typeType.unorm_2_10_10_10:		return Strings.Enum_texture_info_quantize_typeType_unorm_2_10_10_10;
                case texture_info_quantize_typeType.uint_2_10_10_10:		return Strings.Enum_texture_info_quantize_typeType_uint_2_10_10_10;
                case texture_info_quantize_typeType.uint_32_32:				return Strings.Enum_texture_info_quantize_typeType_uint_32_32;
                case texture_info_quantize_typeType.sint_32_32:				return Strings.Enum_texture_info_quantize_typeType_sint_32_32;
                case texture_info_quantize_typeType.float_32_32:			return Strings.Enum_texture_info_quantize_typeType_float_32_32;
                case texture_info_quantize_typeType.unorm_16_16_16_16:		return Strings.Enum_texture_info_quantize_typeType_unorm_16_16_16_16;
                case texture_info_quantize_typeType.uint_16_16_16_16:		return Strings.Enum_texture_info_quantize_typeType_uint_16_16_16_16;
                case texture_info_quantize_typeType.snorm_16_16_16_16:		return Strings.Enum_texture_info_quantize_typeType_snorm_16_16_16_16;
                case texture_info_quantize_typeType.sint_16_16_16_16:		return Strings.Enum_texture_info_quantize_typeType_sint_16_16_16_16;
                case texture_info_quantize_typeType.float_16_16_16_16:		return Strings.Enum_texture_info_quantize_typeType_float_16_16_16_16;
                case texture_info_quantize_typeType.uint_32_32_32_32:		return Strings.Enum_texture_info_quantize_typeType_uint_32_32_32_32;
                case texture_info_quantize_typeType.sint_32_32_32_32:		return Strings.Enum_texture_info_quantize_typeType_sint_32_32_32_32;
                case texture_info_quantize_typeType.float_32_32_32_32:		return Strings.Enum_texture_info_quantize_typeType_float_32_32_32_32;
                case texture_info_quantize_typeType.unorm_bc1:				return Strings.Enum_texture_info_quantize_typeType_unorm_bc1;
                case texture_info_quantize_typeType.srgb_bc1:				return Strings.Enum_texture_info_quantize_typeType_srgb_bc1;
                case texture_info_quantize_typeType.unorm_bc2:				return Strings.Enum_texture_info_quantize_typeType_unorm_bc2;
                case texture_info_quantize_typeType.srgb_bc2:				return Strings.Enum_texture_info_quantize_typeType_srgb_bc2;
                case texture_info_quantize_typeType.unorm_bc3:				return Strings.Enum_texture_info_quantize_typeType_unorm_bc3;
                case texture_info_quantize_typeType.srgb_bc3:				return Strings.Enum_texture_info_quantize_typeType_srgb_bc3;
                case texture_info_quantize_typeType.unorm_bc4:				return Strings.Enum_texture_info_quantize_typeType_unorm_bc4;
                case texture_info_quantize_typeType.snorm_bc4:				return Strings.Enum_texture_info_quantize_typeType_snorm_bc4;
                case texture_info_quantize_typeType.unorm_bc5:				return Strings.Enum_texture_info_quantize_typeType_unorm_bc5;
                case texture_info_quantize_typeType.snorm_bc5:				return Strings.Enum_texture_info_quantize_typeType_snorm_bc5;
                default:
                    {
                        return Enum.GetName(typeof(texture_info_quantize_typeType), value);
                    }


            }

            throw new NotImplementedException();
        }
        #endregion

        #region vtx_attrib_typeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(vtx_attrib_typeType value)
        {
            switch (value)
            {
                default:
                    return System.Enum.GetName(typeof(vtx_attrib_typeType), value);
            }

            throw new NotImplementedException();
        }
        #endregion

        #region input_quantize_typeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(vtx_attrib_quantize_typeType value)
        {
            switch (value)
            {
                default:
                    return value.ToString();//System.Enum.GetName(typeof(input_quantize_typeType), value);
            }

            throw new NotImplementedException();
        }
        #endregion

        #region render_state_typeType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(render_state_modeType value)
        {
            switch (value)
            {
case 		render_state_modeType.custom: return Strings.Enum_render_state_custom;
case 		render_state_modeType.opaque: return Strings.Enum_render_state_opaque;
case 			render_state_modeType.mask: return Strings.Enum_render_state_mask;
case 	render_state_modeType.translucent: return Strings.Enum_render_state_translucent;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region render_state_display_faceType
        /// <summary>
        /// 列挙値。
        /// </summary>
        public static string EnumValue(render_state_display_faceType value)
        {
            switch (value)
            {
                case render_state_display_faceType.both: return Strings.Enum_render_state_display_face_both;
                case render_state_display_faceType.front: return Strings.Enum_render_state_display_face_front;
                case render_state_display_faceType.back: return Strings.Enum_render_state_display_face_back;
                case render_state_display_faceType.none: return Strings.Enum_render_state_display_face_none;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region depth_test_funcType
        public static string EnumValue(depth_test_funcType value)
        {
            switch (value)
            {
                case depth_test_funcType.never: return Strings.Enum_depth_test_funcType_never;
                case depth_test_funcType.less: return Strings.Enum_depth_test_funcType_less;
                case depth_test_funcType.equal: return Strings.Enum_depth_test_funcType_equal;
                case depth_test_funcType.lequal: return Strings.Enum_depth_test_funcType_lequal;
                case depth_test_funcType.greater: return Strings.Enum_depth_test_funcType_greater;
                case depth_test_funcType.nequal: return Strings.Enum_depth_test_funcType_nequal;
                case depth_test_funcType.gequal: return Strings.Enum_depth_test_funcType_gequal;
                case depth_test_funcType.always: return Strings.Enum_depth_test_funcType_always;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region render_state_blend_modeType
        public static string EnumValue(render_state_blend_modeType value)
        {
            switch (value)
            {
case 	render_state_blend_modeType.none: return Strings.Enum_render_state_blend_modeType_none;
case 	render_state_blend_modeType.color: return Strings.Enum_render_state_blend_modeType_color;
case 	render_state_blend_modeType.logic: return Strings.Enum_render_state_blend_modeType_logic;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region alpha_test_funcType
        public static string EnumValue(alpha_test_funcType value)
        {
            switch (value)
            {
case 	alpha_test_funcType.never: return Strings.Enum_alpha_test_funcType_never;
case 		alpha_test_funcType.less: return Strings.Enum_alpha_test_funcType_less;
case 	alpha_test_funcType.equal: return Strings.Enum_alpha_test_funcType_equal;
case 	alpha_test_funcType.lequal: return Strings.Enum_alpha_test_funcType_lequal;
case 	alpha_test_funcType.greater: return Strings.Enum_alpha_test_funcType_greater;
case 	alpha_test_funcType.nequal: return Strings.Enum_alpha_test_funcType_nequal;
case 	alpha_test_funcType.gequal: return Strings.Enum_alpha_test_funcType_gequal;
case 	alpha_test_funcType.always: return Strings.Enum_alpha_test_funcType_always;
            }

            throw new NotImplementedException();
        }
        #endregion
        #region color_blend_opType
        public static string EnumValue(color_blend_opType value)
        {
            switch (value)
            {
case 				color_blend_opType.add: return Strings.Enum_color_blend_opType_add;
case 	color_blend_opType.src_minus_dst: return Strings.Enum_color_blend_opType_src_minus_dst;
case 				color_blend_opType.min: return Strings.Enum_color_blend_opType_min;
case 				color_blend_opType.max: return Strings.Enum_color_blend_opType_max;
case 	color_blend_opType.dst_minus_src: return Strings.Enum_color_blend_opType_dst_minus_src;
            }

            throw new NotImplementedException();
        }
        #endregion
        #region color_blend_rgb_funcType
        public static string EnumValue(color_blend_rgb_funcType value)
        {
            switch (value)
            {
case 					color_blend_rgb_funcType.zero: return Strings.Enum_color_blend_rgb_funcType_zero;
case 						color_blend_rgb_funcType.one: return Strings.Enum_color_blend_rgb_funcType_one;
case 				color_blend_rgb_funcType.src_color: return Strings.Enum_color_blend_rgb_funcType_src_color;
case 		color_blend_rgb_funcType.one_minus_src_color: return Strings.Enum_color_blend_rgb_funcType_one_minus_src_color;
case 				color_blend_rgb_funcType.src_alpha: return Strings.Enum_color_blend_rgb_funcType_src_alpha;
case 		color_blend_rgb_funcType.one_minus_src_alpha: return Strings.Enum_color_blend_rgb_funcType_one_minus_src_alpha;
case 				color_blend_rgb_funcType.dst_color: return Strings.Enum_color_blend_rgb_funcType_dst_color;
case 		color_blend_rgb_funcType.one_minus_dst_color: return Strings.Enum_color_blend_rgb_funcType_one_minus_dst_color;
case 				color_blend_rgb_funcType.dst_alpha: return Strings.Enum_color_blend_rgb_funcType_dst_alpha;
case 		color_blend_rgb_funcType.one_minus_dst_alpha: return Strings.Enum_color_blend_rgb_funcType_one_minus_dst_alpha;
case 				color_blend_rgb_funcType.const_color: return Strings.Enum_color_blend_rgb_funcType_const_color;
case 	color_blend_rgb_funcType.one_minus_const_color: return Strings.Enum_color_blend_rgb_funcType_one_minus_const_color;
case 				color_blend_rgb_funcType.const_alpha: return Strings.Enum_color_blend_rgb_funcType_const_alpha;
case 	color_blend_rgb_funcType.one_minus_const_alpha: return Strings.Enum_color_blend_rgb_funcType_one_minus_const_alpha;
case 				color_blend_rgb_funcType.src1_color: return Strings.Enum_color_blend_rgb_funcType_src1_color;
case 	color_blend_rgb_funcType.one_minus_src1_color: return Strings.Enum_color_blend_rgb_funcType_one_minus_src1_color;
case 				color_blend_rgb_funcType.src1_alpha: return Strings.Enum_color_blend_rgb_funcType_src1_alpha;
case 	color_blend_rgb_funcType.one_minus_src1_alpha: return Strings.Enum_color_blend_rgb_funcType_one_minus_src1_alpha;
case 		color_blend_rgb_funcType.src_alpha_saturate: return Strings.Enum_color_blend_rgb_funcType_src_alpha_saturate;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region color_blend_alpha_funcType
        public static string EnumValue(color_blend_alpha_funcType value)
        {
            switch (value)
            {
case 					color_blend_alpha_funcType.zero: return Strings.Enum_color_blend_alpha_funcType_zero;
case 					color_blend_alpha_funcType.one: return Strings.Enum_color_blend_alpha_funcType_one;
case 				color_blend_alpha_funcType.src_alpha: return Strings.Enum_color_blend_alpha_funcType_src_alpha;
case 	color_blend_alpha_funcType.one_minus_src_alpha: return Strings.Enum_color_blend_alpha_funcType_one_minus_src_alpha;
case 				color_blend_alpha_funcType.dst_alpha: return Strings.Enum_color_blend_alpha_funcType_dst_alpha;
case 	color_blend_alpha_funcType.one_minus_dst_alpha: return Strings.Enum_color_blend_alpha_funcType_one_minus_dst_alpha;
case 			color_blend_alpha_funcType.const_alpha: return Strings.Enum_color_blend_alpha_funcType_const_alpha;
case 	color_blend_alpha_funcType.one_minus_const_alpha: return Strings.Enum_color_blend_alpha_funcType_one_minus_const_alpha;
case 			color_blend_alpha_funcType.src1_alpha: return Strings.Enum_color_blend_alpha_funcType_src1_alpha;
case 	color_blend_alpha_funcType.one_minus_src1_alpha: return Strings.Enum_color_blend_alpha_funcType_one_minus_src1_alpha;
case 	color_blend_alpha_funcType.src_alpha_saturate: return Strings.Enum_color_blend_alpha_funcType_src_alpha_saturate;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region logical_blend_opType
        public static string EnumValue(logical_blend_opType value)
        {
            switch (value)
            {
case 	logical_blend_opType.clear: return Strings.Enum_logical_blend_opType_clear;
case 		logical_blend_opType.set: return Strings.Enum_logical_blend_opType_set;
case 		logical_blend_opType.copy: return Strings.Enum_logical_blend_opType_copy;
case 	logical_blend_opType.inv_copy: return Strings.Enum_logical_blend_opType_inv_copy;
case 	logical_blend_opType.no_op: return Strings.Enum_logical_blend_opType_no_op;
case 		logical_blend_opType.inv: return Strings.Enum_logical_blend_opType_inv;
case 		logical_blend_opType.and: return Strings.Enum_logical_blend_opType_and;
case 		logical_blend_opType.nand: return Strings.Enum_logical_blend_opType_nand;
case 		logical_blend_opType.or: return Strings.Enum_logical_blend_opType_or;
case 		logical_blend_opType.nor: return Strings.Enum_logical_blend_opType_nor;
case 		logical_blend_opType.xor: return Strings.Enum_logical_blend_opType_xor;
case 	logical_blend_opType.equiv: return Strings.Enum_logical_blend_opType_equiv;
case 	logical_blend_opType.rev_and: return Strings.Enum_logical_blend_opType_rev_and;
case 	logical_blend_opType.inv_and: return Strings.Enum_logical_blend_opType_inv_and;
case 	logical_blend_opType.rev_or: return Strings.Enum_logical_blend_opType_rev_or;
case 	logical_blend_opType.inv_or: return Strings.Enum_logical_blend_opType_inv_or;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region MaterialRenderStatePage.BlendPreset
        public static string EnumValue(MaterialRenderStatePage.BlendPresetType value)
        {
            switch (value)
            {
                case MaterialRenderStatePage.BlendPresetType.Custom:	return Strings.Enum_MaterialRenderStatePage_BlendPreset_Custom;
                case MaterialRenderStatePage.BlendPresetType.Blend:		return Strings.Enum_MaterialRenderStatePage_BlendPreset_Blend;
                case MaterialRenderStatePage.BlendPresetType.Add:		return Strings.Enum_MaterialRenderStatePage_BlendPreset_Add;
                case MaterialRenderStatePage.BlendPresetType.Sub:		return Strings.Enum_MaterialRenderStatePage_BlendPreset_Sub;
                case MaterialRenderStatePage.BlendPresetType.Mul:		return Strings.Enum_MaterialRenderStatePage_BlendPreset_Mul;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region ui_item_valueType
        public static string EnumValue(ui_item_valueType value)
        {
            switch (value)
            {
                case ui_item_valueType.auto:	return Strings.Enum_ui_item_value_auto;
                case ui_item_valueType.color:	return Strings.Enum_ui_item_value_color;
                case ui_item_valueType.check: return Strings.Enum_ui_item_value_check;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region curve_frame_typeType
        public static string EnumValue(curve_frame_typeType value)
        {
            switch (value)
            {
                case curve_frame_typeType.none:		return Strings.Enum_Curve_Element_FrameType_None;
                case curve_frame_typeType.frame32:	return Strings.Enum_Curve_Element_FrameType_Frame32;
                case curve_frame_typeType.frame16:	return Strings.Enum_Curve_Element_FrameType_Frame16;
                case curve_frame_typeType.frame8:	return Strings.Enum_Curve_Element_FrameType_Frame8;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region curve_key_typeType
        public static string EnumValue(curve_key_typeType value)
        {
            switch (value)
            {
                case curve_key_typeType.none:	return Strings.Enum_Curve_Element_KeyType_None;
                case curve_key_typeType.key32:	return Strings.Enum_Curve_Element_KeyType_Key32;
                case curve_key_typeType.key16:	return Strings.Enum_Curve_Element_KeyType_Key16;
                case curve_key_typeType.key8:	return Strings.Enum_Curve_Element_KeyType_Key8;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region curve_wrapType
        public static string EnumValue(curve_wrapType value)
        {
            switch (value)
            {
                case curve_wrapType.clamp:	return Strings.Enum_Curve_Element_Wrap_Clamp;
                case curve_wrapType.repeat:	return Strings.Enum_Curve_Element_Wrap_Repeat;
                case curve_wrapType.mirror:	return Strings.Enum_Curve_Element_Wrap_Mirror;
                case curve_wrapType.relative_repeat: return Strings.Enum_Curve_Element_Wrap_RelativeRepeat;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region camera_anim_rotate_modeType
        public static string EnumValue(camera_anim_rotate_modeType value)
        {
            switch (value)
            {
                case camera_anim_rotate_modeType.aim: return Strings.Enum_camera_anim_rotate_modeType_aim;
                case camera_anim_rotate_modeType.euler_zxy: return Strings.Enum_camera_anim_rotate_modeType_euler_xyz;
            }
            throw new NotImplementedException();
        }
        #endregion

        #region camera_anim_projection_modeType
        public static string EnumValue(camera_anim_projection_modeType value)
        {
            switch (value)
            {
                case camera_anim_projection_modeType.ortho : return Strings.Enum_camera_anim_projection_modeType_ortho;
                case camera_anim_projection_modeType.persp : return Strings.Enum_camera_anim_projection_modeType_persp;
            }
            throw new NotImplementedException();
        }
        #endregion

        #region block_var_typeType
        public static string EnumValue(block_var_typeType value)
        {
            switch (value)
            {
                case block_var_typeType.none: return Strings.Enum_block_var_type_none;
                case block_var_typeType.material: return Strings.Enum_block_var_type_material;
                case block_var_typeType.shape: return Strings.Enum_block_var_type_shape;
                case block_var_typeType.skeleton: return Strings.Enum_block_var_type_skeleton;
                case block_var_typeType.option: return Strings.Enum_block_var_type_option;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region shader_storage_block_var_typeType
        public static string EnumValue(shader_storage_block_var_typeType value)
        {
            switch (value)
            {
                case shader_storage_block_var_typeType.none: return Strings.Enum_shader_storage_block_var_type_none;
                case shader_storage_block_var_typeType.skeleton: return Strings.Enum_shader_storage_block_var_type_skeleton;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region AnimationDocument.NonEditableKind
        public static string EnumValue(AnimationDocument.NonEditableKind value, object displayAux = null)
        {
            switch (value)
            {
                case AnimationDocument.NonEditableKind.ShaderParamAnim_DisableByOptionVar:
                {
                    var displayAuxString = displayAux as string;
                    if (displayAuxString != null)
                    {
                        return string.Format(Strings.NonEditableKind_ShaderParamAnim_DisableByOptionVar, displayAuxString);
                    }
                    else
                    {
                        return Strings.NonEditableKind_ShaderParamAnim_DisableByOptionVar_NoGroup;
                    }
                }

                case AnimationDocument.NonEditableKind.ShaderParamAnim_NotFoundParam:		return Strings.NonEditableKind_ShaderParamAnim_NotFoundParam;
                case AnimationDocument.NonEditableKind.ShaderParamAnim_NotFoundMaterial:	return Strings.NonEditableKind_ShaderParamAnim_NotFoundMaterial;
                case AnimationDocument.NonEditableKind.ShaderParamAnim_NotBindModel:		return Strings.NonEditableKind_ShaderParamAnim_NotBindModel;
                case AnimationDocument.NonEditableKind.ShaderParamAnim_NotAssignShaderDef:	return Strings.NonEditableKind_ShaderParamAnim_NotAssignShaderDef;
                case AnimationDocument.NonEditableKind.ShaderParamAnim_NotLoadShaderDef:	return Strings.NonEditableKind_ShaderParamAnim_NotLoadShaderDef;
                case AnimationDocument.NonEditableKind.ShaderParamAnim_NotShadingModel:		return Strings.NonEditableKind_ShaderParamAnim_NotShadingModel;
                case AnimationDocument.NonEditableKind.ShaderParamAnim_TypeConflict:		return Strings.NonEditableKind_ShaderParamAnim_TypeConflict;
                case AnimationDocument.NonEditableKind.ShaderParamAnim_InvalidType:			return Strings.NonEditableKind_ShaderParamAnim_InvalidType;
                case AnimationDocument.NonEditableKind.ShaderParamAnim_Invisible:			return Strings.NonEditableKind_ShaderParamAnim_Invisible;
                case AnimationDocument.NonEditableKind.BoneVisibility_NotFoundBone:			return Strings.NonEditableKind_BoneVisibility_NotFoundBone;
                case AnimationDocument.NonEditableKind.BoneVisibility_NotBinarize:          return Strings.NonEditableKind_BoneVisibility_NotBinarize;
                case AnimationDocument.NonEditableKind.MaterialVisibility_NotFoundMaterial: return Strings.NonEditableKind_MaterialVisibility_NotFoundMaterial;
                case AnimationDocument.NonEditableKind.Light_NotFoundType:					return Strings.NonEditableKind_Light_NotFoundType;
                case AnimationDocument.NonEditableKind.TexturePattern_NotFoundSampler:		return Strings.NonEditableKind_TexturePattern_NotFoundSampler;
                case AnimationDocument.NonEditableKind.SkeletalAnimation_NotEditable:       return Strings.NonEditableKind_SkeletalAnimation_NotEditable;
                case AnimationDocument.NonEditableKind.ShapeAnimation_NotEditable:          return Strings.NonEditableKind_ShapeAnimation_NotEditable;
                case AnimationDocument.NonEditableKind.Editable: return Strings.NonEditableKind_Editable;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region ui_visible_valueType
        public static string EnumValue(ui_visible_valueType value)
        {
            switch (value)
            {
                case ui_visible_valueType.@true: return Strings.Enum_ui_visible_value_true;
                case ui_visible_valueType.@false: return Strings.Enum_ui_visible_value_false;
                case ui_visible_valueType.param_only: return Strings.Enum_ui_visible_value_param_only;
                case ui_visible_valueType.anim_only: return Strings.Enum_ui_visible_value_anim_only;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region Project.RelativeType
        public static string EnumValue(Project.RelativeType value)
        {
            switch (value)
            {
                case Project.RelativeType.Project:
                    return res.Strings.Enum_ProjectRelativeType_Project;
                case Project.RelativeType.StartUpFolder:
                    return res.Strings.Enum_ProjectRelativeType_StartUpFolder;
                case Project.RelativeType.SearchPath:
                    return res.Strings.Enum_ProjectRelativeType_SearchPath;
                case Project.RelativeType.StartUp:
                    // 来ないはず
                    Debug.Assert(false);
                    return res.Strings.Enum_ProjectRelativeType_SearchPath;
            }

            throw new NotImplementedException();
        }
        #endregion

        #region DialogResult
        public static string EnumValue(DialogResult value)
        {
            switch (value)
            {
                case DialogResult.Abort:
                    return res.Strings.Enum_DialogResult_Abort;
                case DialogResult.Cancel:
                    return res.Strings.Enum_DialogResult_Cancel;
                case DialogResult.Ignore:
                    return res.Strings.Enum_DialogResult_Ignore;
                case DialogResult.No:
                    return res.Strings.Enum_DialogResult_No;
                case DialogResult.None:
                    // 来ないはず
                    Debug.Assert(false);
                    return "None";
                case DialogResult.OK:
                    return res.Strings.Enum_DialogResult_Ok;
                case DialogResult.Retry:
                    return res.Strings.Enum_DialogResult_Retry;
                case DialogResult.Yes:
                    return res.Strings.Enum_DialogResult_Yes;
            }
            throw new NotImplementedException();
        }
        #endregion
    }
}
