﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Windows.Forms;

namespace App.PropertyEdit
{
    /// <summary>
    /// プロパティカテゴリノードクラス。
    /// </summary>
    public sealed class PropertyCategoryNode : TreeNode
    {
        private readonly CreatePropertyPageHandler _createPageHandler = null;
        private readonly object                    _createPageArg     = null;
        private ObjectPropertyPage                 _propertyPage      = null;

        public bool ValidPage;

        public Func<bool> IsValidPage = null;

        public PropertyPageID PageID;

        public bool ShowModifiedMark;

        public Func<bool> UpdateModified;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public PropertyCategoryNode(
            string                    text,
            int                       imageIndex,
            PropertyPageID pageID,
            CreatePropertyPageHandler createPageHandler,
            object                    createPageArg
        )
            : base(text, imageIndex, imageIndex)
        {
            PageID = pageID;
            _createPageHandler = createPageHandler;
            _createPageArg     = createPageArg;
        }

        /// <summary>
        /// プロパティページ。
        /// </summary>
        public ObjectPropertyPage PropertyPage
        {
            get { return _propertyPage; }

            // 共有の設定用に set を public にした。
            set { _propertyPage = value; }
        }

        /// <summary>
        /// プロパティページ作成。
        /// </summary>
        public ObjectPropertyPage CreatePropertyPage()
        {
            Debug.Assert(_propertyPage == null);

            // 作成して保持

            _propertyPage = _createPageHandler(_createPageArg);
            if (PropertyPageCreated != null)
            {
                PropertyPageCreated(this, _propertyPage);
            }

            return _propertyPage;
        }

        /// <summary>
        /// 同じページ作成ハンドラを持つノードを検索。
        /// </summary>
        public PropertyCategoryNode Search(PropertyCategoryNode node)
        {
            // 等値比較する（参照比較は駄目）
            if (_createPageHandler.Equals(node._createPageHandler) && FullPath == node.FullPath)
            {
                return this;
            }

            // 子ノードを再帰的に検索
            foreach (PropertyCategoryNode child in Nodes)
            {
                PropertyCategoryNode result = child.Search(node);
                if (result != null)
                {
                    return result;
                }
            }
            return null;
        }

        public event Action<PropertyCategoryNode, ObjectPropertyPage> PropertyPageCreated;
    }
}
