﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using App.Controls;

namespace App.PropertyEdit
{
    /// <summary>
    /// カテゴリビュークラス。
    /// </summary>
    public sealed class CategoryView : UITreeView
    {
        public CategoryView()
        {
            DrawMode = TreeViewDrawMode.OwnerDrawText;
        }

        protected override void OnKeyPress(KeyPressEventArgs e)
        {
            e.Handled = true;
            base.OnKeyPress(e);
        }

        protected override void OnDrawNode(DrawTreeNodeEventArgs e)
        {
            var bgBounds = e.Node.Bounds;

            // この状態は描画しない
            if ((bgBounds.X == 0) && (bgBounds.Y == 0))
            {
                return;
            }

            var graphics = e.Graphics;
            var font     = e.Node.NodeFont ?? Font;
            var node     = e.Node as PropertyCategoryNode;
            Debug.Assert(node != null, "node != null");
            graphics.FillRectangle(SystemBrushes.Window, bgBounds);

            if (node.ShowModifiedMark)
            {
                graphics.DrawImage(ModifiedMark.StarMark, new Point(bgBounds.Left, bgBounds.Top));

                bgBounds.X += ModifiedMark.StarMark.Width + 2;	// +2 はテキストの選択ボックスとくっついてしまうので
            }

            if (node.IsSelected)
            {
                graphics.FillRectangle(SystemBrushes.Highlight, bgBounds);
                TextRenderer.DrawText(graphics, e.Node.Text, font, new Point(bgBounds.X, bgBounds.Y), node.ValidPage? Color.White : Color.Red);
            }
            else
            {
                TextRenderer.DrawText(graphics, e.Node.Text, font, new Point(bgBounds.X, bgBounds.Y), node.ValidPage ? Color.Black: Color.Red);
            }
        }
    }
}
