﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using App.Data;
using App.res;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class SkeletalAnimationPropertyPanel : AnimationObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgCurveEdit;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public SkeletalAnimationPropertyPanel()
        {
            InitializeCategoryView();

            IsSortByAlphabeticalVisible = true;
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_SkeletalAnimation_Root, PropertyPageID.SkeletalAnimationRoot, SkeletalAnimationRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_SkeletalAnimation_General, PropertyPageID.SkeletalAnimationGeneral, SkeletalAnimationGeneralPage.CreateInstance,
                    updateModifiedFunc: () => SkeletalAnimationGeneralPage.IsModified(ActiveTarget));
                ctgCurveEdit = RegisterCategory(1, Strings.ObjectPropertyPanel_BoneVisibilityAnimation_CurveEdit, PropertyPageID.SkeletalAnimationCurveEdit, SkeletalAnimationCurveEditPage.CreateInstance,
                    updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
            var ctgPreview = RegisterCategory(4, Strings.ObjectPropertyPanel_SkeletalAnimation_Preview, PropertyPageID.SkeletalAnimationPreview, SkeletalAnimationPreviewPage.CreateInstance,
                    updateModifiedFunc: () => SkeletalAnimationPreviewPage.IsModified(ActiveTarget));
            var ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation, PropertyPageID.FileInformation, FileInformationPage.CreateInstance,
                    updateModifiedFunc: () => FileInformationPage.IsModified(ActiveTarget));
            var ctgOptLog = RegisterCategory(1, Strings.ObjectPropertyPanel_OptimizationLog, PropertyPageID.OptimizationLog, OptimizationLogPage.CreateInstance);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgCurveEdit);
                ctgRoot.Nodes.Add(ctgPreview);
                ctgRoot.Nodes.Add(ctgFileInfo);
                ctgRoot.Nodes.Add(ctgOptLog);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private SkeletalAnimation ActiveTarget
        {
            get { return (SkeletalAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgCurveEdit;
        }
    }
}
