﻿using App.Data;
using App.res;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class ProjectPropertyPanel : ObjectPropertyPanel
    {
        private PropertyCategoryNode ctgFileInfo;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ProjectPropertyPanel()
        {
            InitializeCategoryView();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_project_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_Project_Root, PropertyPageID.ProjectRoot, ProjectRootPage.CreateInstance);
            ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation, PropertyPageID.ProjctFileInformation, ProjectFileInformationPage.CreateInstance,
                updateModifiedFunc: () => ProjectFileInformationPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgFileInfo);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private ProjectDocument ActiveTarget
        {
            get { return (ProjectDocument)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgFileInfo;
        }
    }
}
