﻿using App.Data;
using App.res;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class MaterialVisibilityAnimationPanel : AnimationObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgCurveEdit;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialVisibilityAnimationPanel()
        {
            InitializeCategoryView();

            IsOnlyTargetShowNodeVisible = true;
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_MaterialVisibilityAnimation_Root, PropertyPageID.MaterialVisibilityAnimationRoot, MaterialVisibilityAnimationRootPage.CreateInstance);
            ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_MaterialVisibilityAnimation_General, PropertyPageID.MaterialVisibilityAnimationGeneral, MaterialVisibilityAnimationGeneralPage.CreateInstance,
                updateModifiedFunc: () => MaterialVisibilityAnimationGeneralPage.IsModified(ActiveTarget));
            ctgCurveEdit = RegisterCategory(1, Strings.ObjectPropertyPanel_MaterialVisibilityAnimation_CurveEdit, PropertyPageID.MaterialVisibilityAnimationCurveEdit, MaterialVisibilityAnimationCurveEditPage.CreateInstance,
                updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
            var ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation, PropertyPageID.FileInformation, FileInformationPage.CreateInstance,
                updateModifiedFunc: () => FileInformationPage.IsModified(ActiveTarget));
            var ctgOptLog = RegisterCategory(1, Strings.ObjectPropertyPanel_OptimizationLog, PropertyPageID.OptimizationLog, OptimizationLogPage.CreateInstance);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgCurveEdit);
                ctgRoot.Nodes.Add(ctgFileInfo);
                ctgRoot.Nodes.Add(ctgOptLog);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private MaterialVisibilityAnimation ActiveTarget
        {
            get { return (MaterialVisibilityAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgCurveEdit;
        }

    }
}
