﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using App.Data;
using App.res;
using System.Linq;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class MaterialAnimationPropertyPanel : AnimationObjectPropertyPanel, IHasShaderParameterCurvePage, IHasTexturePatternCurvePage
    {
        private PropertyCategoryNode ctgRoot;
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgPattern;
        private PropertyCategoryNode ctgCurveEdit;
        private PropertyCategoryNode ctgOriginal;
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialAnimationPropertyPanel(ObjectPropertyDialog.PanelID panelID)
        {
            InitializeCategoryView(panelID);

            IsShaderParamAnimGroupCondShowVisible = true;
            IsOnlyTargetShowNodeVisible = true;
            IsShowKeyedMaterialVisible = true;
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private bool showPatternPage = false;

        private void InitializeCategoryView(ObjectPropertyDialog.PanelID panelID)
        {
            var rootText = panelID == ObjectPropertyDialog.PanelID.ColorAnimation ? Strings.ObjectPropertyPanel_ColorAnimation_Root :
                panelID == ObjectPropertyDialog.PanelID.TextureSrtAnimation ? Strings.ObjectPropertyPanel_TextureSrtAnimation_Root :
                Strings.ObjectPropertyPanel_MaterialAnimation_Root;
            // カテゴリ登録
                ctgRoot = RegisterCategory(0, rootText, PropertyPageID.MaterialAnimationRoot, MaterialAnimationRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_MaterialAnimation_General, PropertyPageID.MaterialAnimationGeneral, MaterialAnimationGeneralPage.CreateInstance,
                    updateModifiedFunc: () => MaterialAnimationGeneralPage.IsModified(ActiveTarget));
                ctgPattern = RegisterCategory(1, Strings.ObjectPropertyPanel_MaterialAnimation_Pattern, PropertyPageID.MaterialAnimationPattern, MaterialAnimationPatternPage.CreateInstance,
                    updateModifiedFunc: () => MaterialAnimationPatternPage.IsModified(ActiveTarget));
                ctgCurveEdit = RegisterCategory(1, Strings.ObjectPropertyPanel_MaterialAnimation_CurveEdit, PropertyPageID.MaterialAnimationCurveEdit, MaterialAnimationCurveEditPage.CreateInstance,
                    updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
                ctgOriginal = RegisterCategory(1, Strings.ObjectPropertyPanel_MaterialAnimation_Original, PropertyPageID.MaterialAnimationOriginal, MaterialAnimationOriginalInfoPage.CreateInstance);

            var ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation, PropertyPageID.FileInformation, FileInformationPage.CreateInstance,
                    updateModifiedFunc: () => FileInformationPage.IsModified(ActiveTarget));
            var ctgSearchPath = RegisterCategory(1, Strings.ObjectPropertyPanel_Model_SearchPath, PropertyPageID.ModelSearchPath, SearchPathPage.CreateInstance,
                    updateModifiedFunc: () => SearchPathPage.IsModified(ActiveTarget));
            var ctgOptLog = RegisterCategory(1, Strings.ObjectPropertyPanel_OptimizationLog, PropertyPageID.OptimizationLog, OptimizationLogPage.CreateInstance);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgPattern);
                ctgRoot.Nodes.Add(ctgCurveEdit);
                ctgRoot.Nodes.Add(ctgOriginal);
                ctgRoot.Nodes.Add(ctgFileInfo);
                ctgRoot.Nodes.Add(ctgSearchPath);
                ctgRoot.Nodes.Add(ctgOptLog);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
            showPatternPage = true;
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private MaterialAnimation ActiveTarget
        {
            get { return (MaterialAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgCurveEdit;
        }

        /// <summary>
        /// カーブページを開きカーブを選択する
        /// </summary>
        public void SelectShaderParameterCurvePage(System.Collections.Generic.IEnumerable<string> materials, string uniform, int? componentIndex)
        {
            CategoryView.SelectedNode = ctgCurveEdit;
            var curvePage = (MaterialAnimationCurveEditPage)ActivePage;
            if (materials != null)
            {
                materials = materials.Where(x => !string.IsNullOrEmpty(x));
                if (materials.Any())
                {
                    curvePage.Select(materials.ToArray(), uniform, true, componentIndex);
                }
            }
        }

        public void SelectTexturePatternCurvePage(System.Collections.Generic.IEnumerable<string> materials, string sampler)
        {
            CategoryView.SelectedNode = ctgCurveEdit;
            var curvePage = (MaterialAnimationCurveEditPage)ActivePage;
            if (materials != null)
            {
                materials = materials.Where(x => !string.IsNullOrEmpty(x));
                if (materials.Any())
                {
                    curvePage.Select(materials.ToArray(), sampler, false, null);
                }
            }
        }

        /// <summary>
        /// フィットする
        /// SelectCurvePage の後で行う
        /// </summary>
        public void FitCurvePage()
        {
            var curvePage = (MaterialAnimationCurveEditPage)ActivePage;
            curvePage.FitAfterSelect();
        }

        private void InitializeComponent()
        {
            ((System.ComponentModel.ISupportInitialize)(spcLeft)).BeginInit();
            spcLeft.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(spcClient)).BeginInit();
            spcClient.Panel1.SuspendLayout();
            spcClient.SuspendLayout();
            SuspendLayout();
            //
            // spcLeft
            //
            spcLeft.Size = new System.Drawing.Size(180, 538);
            //
            // spcClient
            //
            //
            // MaterialAnimationPropertyPanel
            //
            AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
            Name = "MaterialAnimationPropertyPanel";
            ((System.ComponentModel.ISupportInitialize)(spcLeft)).EndInit();
            spcLeft.ResumeLayout(false);
            spcClient.Panel1.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(spcClient)).EndInit();
            spcClient.ResumeLayout(false);
            ResumeLayout(false);

        }

        protected override void UpdateFormInternal()
        {
            var show = ActiveTarget.IsTexturePatternType() || ActiveTarget.TexPatterns.Count > 0;
            if (showPatternPage != show)
            {
                showPatternPage = show;
                if (show)
                {
                    ctgRoot.Nodes.Insert(ctgRoot.Nodes.IndexOf(ctgCurveEdit), ctgPattern);
                }
                else
                {
                    ctgRoot.Nodes.Remove(ctgPattern);
                }
            }

            base.UpdateFormInternal();
        }
    }
}
