﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using App.Controls;
using App.Data;
using App.res;

namespace App.PropertyEdit
{
    public partial class ShaderParameterAnimationMaterialSelectDialog : OkCancelDialog
    {
        public string MaterialName
        {
            get { return cmbMaterialName.Text; }
        }

        private readonly ShaderParameterAnimation shaderParamAnimation_;

        public ShaderParameterAnimationMaterialSelectDialog(ShaderParameterAnimation shaderParamAnimation)
        {
            InitializeComponent();

            shaderParamAnimation_ = shaderParamAnimation;

            cmbMaterialName.Items.AddRange(ParentModelMaterialNames.ToArray());
        }

        private IEnumerable<string> ParentModelMaterialNames
        {
            get
            {
                return
                    from model in DocumentManager.Models
                    from anim in model.AllAnimations
                    where anim == shaderParamAnimation_
                    from material in model.Materials
                    select material.Data.name;
            }
        }

        private void ShaderParameterAnimationMaterialSelectDialog_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (DialogResult == DialogResult.OK)
            {
                // 空文字列でないか
                {
                    if (MaterialName == string.Empty)
                    {
                        UIMessageBox.Warning(Strings.MaterialSelectDialog_EmptyName);
                        e.Cancel = true;
                        return;
                    }
                }

                // 使えない文字が入っていないか
                {
                    if (Material.IsValidateNameString(MaterialName) == false)
                    {
                        UIMessageBox.Warning(Strings.MaterialSelectDialog_InvalidateCharacter);
                        e.Cancel = true;
                        return;
                    }
                }

                // 重複チェック
                {
                    var isExist =
                        (from shaderParamMatAnim in shaderParamAnimation_.ShaderParamAnims
                         where shaderParamMatAnim.mat_name == MaterialName
                         select shaderParamMatAnim).FirstOrDefault() != null;

                    if (isExist)
                    {
                        UIMessageBox.Warning(Strings.MaterialSelectDialog_AlreadyExistMaterial);
                        e.Cancel = true;
                        return;
                    }
                }
            }
        }
    }
}
