﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Drawing;
using System.Drawing.Drawing2D;

namespace App.PropertyEdit
{
    public static class CurveEditorConst
    {
        private static readonly Pen		curveGridPen					= new Pen(Color.FromArgb(83, 83, 83));
        private static readonly Pen		curveGridMinPen					= new Pen(Color.FromArgb(90, 90, 90));
        private static readonly Pen		curveAxisPen					= new Pen(Color.FromArgb(122, 122, 122), 1);
        private static readonly Brush	curveInnerAnimRangeBrush		= new SolidBrush(Color.FromArgb(96, 96, 96));
        private static readonly Brush	curveOuterAnimRangeBrush		= new SolidBrush(Color.FromArgb(86, 86, 86));
        private static readonly Brush	curveFontDarkBrush				= new SolidBrush(Color.FromArgb(30, 30, 30));
        private static readonly Brush	curveFontLightBrush				= new SolidBrush(Color.FromArgb(230, 230, 230));
        private static readonly Brush	curveSelectedKeyFontBrush		= new SolidBrush(Color.FromArgb(230, 230, 0));
        private static readonly Pen		curveSelectedKeyHandlePen		= new Pen(Color.FromArgb(230, 230, 0), 2);
        private static readonly Pen		curveInHandlePen				= new Pen(Color.FromArgb(0, 255, 255));
        private static readonly Pen		curveOutHandlePen				= new Pen(Color.FromArgb(255, 0, 255));
        private static readonly Brush	curveEnabledKeyBrush			= new SolidBrush(Color.FromArgb(255, 255, 255));
        private static readonly Pen		curveEnabledKeyPen				= new Pen(Color.FromArgb(0, 0, 0), 1.6f);
        private static readonly Brush	curveSelectedEnabledKeyBrush	= new SolidBrush(Color.FromArgb(255, 255, 255));  // new SolidBrush(Color.FromArgb(255, 216, 0));
        private static readonly Pen		curveSelectedEnabledKeyPen		= new Pen(Color.FromArgb(255, 255, 255), 1.6f);
        private static readonly Brush	curveDisabledKeyBrush			= curveSelectedEnabledKeyBrush;
        private static readonly Pen		curveDisabledKeyPen				= new Pen(Color.FromArgb(128, 128, 128), 1.6f);
        private static readonly Brush	curveSelectedDisabledKeyBrush	= new SolidBrush(Color.FromArgb(189, 189, 189));
        private static readonly Pen		curveSelectedDisabledKeyPen		= curveDisabledKeyPen;
        private static readonly Pen		curveMinMaxPen					= new Pen(Color.Black, 4.0F) { StartCap = LineCap.ArrowAnchor };
        private static readonly Pen		rulerGridPen					= new Pen(Color.FromArgb(120, 120, 120));
        private static readonly Pen		rulerAxisPen					= curveAxisPen;
        private static readonly Brush	rulerInAnimFrameBrush			= new SolidBrush(Color.FromArgb(160, 160, 160));
        private static readonly Brush	rulerOutAnimFrameBrush			= new SolidBrush(Color.FromArgb(140, 140, 140));
        private static readonly Pen		singleCurvePen					= new Pen(Color.FromArgb(20, 20, 20));
        private static readonly Pen		selectionPen					= new Pen(Color.FromArgb(200, 50, 50, 50));
        private static readonly Brush	selectionBrush					= new SolidBrush(Color.FromArgb(20, 50, 50, 50));
        private static readonly Pen		curveValueRangePen				= new Pen(Color.BlueViolet){ DashStyle = DashStyle.Dash	};
        private static readonly Brush	curveValueRangeBrush			= new SolidBrush(Color.FromArgb(24, Color.BlueViolet.R, Color.BlueViolet.G, Color.BlueViolet.B));
        private static readonly Pen     keySnapLinePen              	= new Pen(Color.LightGray) { DashStyle = DashStyle.DashDot};

        public static Pen	CurveBorderPen{					get{	return Pens.Black;						} }
        public static Pen	CurveGridPen{					get{	return curveGridPen;					} }
        public static Pen	CurveGridMinPen{				get{	return curveGridMinPen;					} }
        public static Pen	CurveAxisPen{					get{	return curveAxisPen;					} }
        public static Brush	CurveInnerAnimRangeBrush{		get{	return curveInnerAnimRangeBrush;		} }
        public static Brush	CurveOuterAnimRangeBrush{		get{	return curveOuterAnimRangeBrush;		} }
        public static Brush	CurveFontDarkBrush{				get{	return curveFontDarkBrush;				} }
        public static Brush	CurveFontLightBrush{			get{	return curveFontLightBrush;				} }
        public static Brush	CurveSelectedKeyFontBrush{		get{	return curveSelectedKeyFontBrush;		} }
        public static Pen	CurveSelectedKeyHandlePen{		get{	return curveSelectedKeyHandlePen;		} }
        public static Pen	CurveInHandlePen{				get{	return curveInHandlePen;				} }
        public static Pen	CurveOutHandlePen{				get{	return curveOutHandlePen;				} }
        public static Brush	CurveEnabledKeyBrush{			get{	return curveEnabledKeyBrush;			} }
        public static Pen	CurveEnabledKeyPen{				get{	return curveEnabledKeyPen;				} }
        public static Brush	CurveSelectedEnabledKeyBrush{	get{	return curveSelectedEnabledKeyBrush;	} }
        public static Pen	CurveSelectedEnabledKeyPen{		get{	return curveSelectedEnabledKeyPen;		} }
        public static Brush	CurveDisabledKeyBrush{			get{	return curveDisabledKeyBrush;			} }
        public static Pen	CurveDisabledKeyPen{			get{	return curveDisabledKeyPen;				} }
        public static Brush	CurveSelectedDisabledKeyBrush{	get{	return curveSelectedDisabledKeyBrush;	} }
        public static Pen	CurveSelectedDisabledKeyPen{	get{	return curveSelectedDisabledKeyPen;		} }
        public static Pen	CurveMinMaxPen{					get{	return curveMinMaxPen;					} }

        public static Pen	RulerGridPen{			get{	return rulerGridPen;			} }
        public static Pen	RulerAxisPen{			get{	return rulerAxisPen;			} }
        public static Brush	RulerInAnimFrameBrush{	get{	return rulerInAnimFrameBrush;	} }
        public static Brush	RulerOutAnimFrameBrush{	get{	return rulerOutAnimFrameBrush;	} }
        public static Pen	CurveHandlePen{			get{	return singleCurvePen;			} }

        public static Pen	CurveCurrentFramePen{	get{	return Pens.Red;				} }
        public static Brush CurveCurrentFrameBrush{	get{	return Brushes.Red;				} }

        public static Pen CurveCurrentFramePenNotPreviewed { get { return Pens.Black; } }
        public static Brush CurveCurrentFrameBrushNotPreviewed{	get{	return Brushes.Black;				} }

        public static Pen CurvePausingFramePen { get { return Pens.Blue; } }
        public static Brush CurvePausingFrameBrush { get { return Brushes.Blue; } }

        public static Pen	CurveClampLinePen{		get{	return Pens.Lime;				} }

        // カーブ描画ペン
        public static Pen	CurveBoolPen{			get{	return singleCurvePen;			} }
        public static Pen	CurveIntPen{			get{	return singleCurvePen;			} }
        public static Pen	CurveFloatPen{			get{	return singleCurvePen;			} }
        public static Pen	CurveVectorXPen{		get{	return Pens.Red;				} }
        public static Pen	CurveVectorYPen{		get{	return Pens.Green;				} }
        public static Pen	CurveVectorZPen{		get{	return Pens.Blue;				} }
        public static Pen	CurveColorRPen{			get{	return Pens.Red;				} }
        public static Pen	CurveColorGPen{			get{	return Pens.Green;				} }
        public static Pen	CurveColorBPen{			get{	return Pens.Blue;				} }
        public static Pen	CurveColorAPen{			get{	return singleCurvePen;			} }

        // 選択矩形
        public static Pen	SelectionPen{			get{	return selectionPen;			} }
        public static Brush	SelectionBrush{			get{	return selectionBrush;			} }

        // カーブ値範囲
        public static Pen	CurveValueRangePen{		get{	return curveValueRangePen;		} }
        public static Brush	CurveValueRangeBrush{	get{	return curveValueRangeBrush;	} }

        // キースナップ用補助線
        public static Pen KeySnapLinePen { get { return keySnapLinePen; } }

        public static int RulerSizeV { get { return 32+6;}}
        public static int RulerSizeH { get { return 32 + 6 /*+(12 + 5)*/; } } // カラーバー分だけ V より大きい
        public static int		GridUnitInterval{	get{	return 100;		} }
        public static int		ColorBarSize{		get{	return 12+5;	} }

        //
        public static double	CurveViewFitMarginX{	get{	return 64.0;	} }
        public static double CurveViewFitMarginY { get { return 76.0; } }
        public static double CurveViewFitOffsetY { get { return 6.0; } }

        //
        public static double	DragSensitivity{		get{	return 0.003;	} }	// ドラッグ感度
        public static double	WheelSensitivity{		get{	return 0.5;		} }	// ホイール感度
        public static double	ScaleEditSensitivity{	get{	return 0.02f;	} }	// スケール編集時の感度

        //
        public static double	HandleLineLengthScale{ get{ return 50.0;	} }
    }

    public enum EditModeType
    {
        Near,
        Multi,
        Scale,
        Insert,
        Add
    }
}
