﻿using System.Linq;
using App.Command;
using App.Controls;
using App.Data;

namespace App.PropertyEdit
{
    public partial class TexturePatternAnimationRootPage : TexturePatternAnimationPropertyPage
    {
        public TexturePatternAnimationRootPage() :
            base(PropertyPageID.TexturePatternAnimationRoot)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new TexturePatternAnimationRootPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            ;
        }

        #region コピー＆ペースト
        private class CopyData
        {
 			public object TexturePatternAnimationGeneralPage{ get; set; }
 			public object TexturePatternAnimationPatternPage{ get; set; }
 			public object TexturePatternAnimationCurveEditPage{ get; set; }
 			public object UserDataPage{ get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return true;
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(TexturePatternAnimation target)
        {
            return
                new CopyData()
                {
                    TexturePatternAnimationGeneralPage = TexturePatternAnimationGeneralPage.Copy(target),
                    TexturePatternAnimationPatternPage = TexturePatternAnimationPatternPage.Copy(target),
                    TexturePatternAnimationCurveEditPage = TexturePatternAnimationCurveEditPage.Copy(target),
                    UserDataPage = UserDataPage.Copy(target)
                };
        }

        public override bool CanPaste(object copiedObjectInfo, object copiedObject)
        {
            var data = (CopyData)copiedObject;

            return TexturePatternAnimationPatternPage.CanPaste((TexturePatternAnimationPatternPage.CopyData)data.TexturePatternAnimationPatternPage);
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            var copyData = (CopyData)pasteObject;
            var patternPage = (TexturePatternAnimationPatternPage.CopyData)copyData.TexturePatternAnimationPatternPage;
            var curveEditPage = (TexturePatternAnimationCurveEditPage.CopyData)copyData.TexturePatternAnimationCurveEditPage;
            if (Viewer.Manager.Instance.IsConnected &&
                TexturePatternAnimation.AllKeys(curveEditPage.TexPatternMatAnims)
                .Any(x => x.Value < 0 || patternPage.TexPatterns.Count <= x.Value))
            {
                if (UIMessageBox.OkCancel(res.Strings.TexturePatternAnimation_OutOfRange_Paste))
                {
                    Viewer.Manager.Instance.Close();
                }
                else
                {
                    return;
                }
            }

            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            using (var vdsb = new Viewer.ViewerDrawSuppressBlock(AnimationCurveEditCommand.AnimationMessageFilter))
            {
                var commandSet = new EditCommandSet();
                commandSet.SetViewerDrawSuppressBlockDelegate(AnimationCurveEditCommand.AnimationMessageFilter);
                {
                    var copyData = (CopyData)pasteObject;

                    commandSet.Add(TexturePatternAnimationGeneralPage.Paste(targets, copyData.TexturePatternAnimationGeneralPage));
                    commandSet.Add(TexturePatternAnimationPatternPage.Paste(targets, copyData.TexturePatternAnimationPatternPage));
                    commandSet.Add(TexturePatternAnimationCurveEditPage.Paste(targets, copyData.TexturePatternAnimationCurveEditPage));
                    commandSet.Add(UserDataPage.Paste(targets, copyData.UserDataPage));
                }

                commandSet.Reverse();
                return commandSet;
            }
        }
        #endregion
    }
}
