﻿using System;
using System.Windows.Forms;
using System.Linq;
using App.Command;
using App.Controls;
using App.Data;
using ConfigCommon;
using Viewer;

namespace App.PropertyEdit
{
    public partial class ModelLodPage : ModelPropertyPage
    {
        public ModelLodPage() :
            base(PropertyPageID.ModelLod)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_model_property_window_lod_model_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new ModelLodPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            // Lod
            using (var ub = new UpdateBlock(lvwLod))
            {
                var levelCount = ActiveTarget.LodInfoArray.Length;

                // 項目が複数あるときは合計も表示
                lvwLod.SetItemCount(levelCount <= 1 ? levelCount: levelCount + 1);

                for (int level = 0; level < levelCount; level++)
                {
                    ListViewItem item = lvwLod.Items[level];

                    // 選択をクリア
                    //item.Selected = false;

                    // LODLevelをTagにセット
                    item.Tag = level;
                    // LOD レベル
                    item.SubItems[clhLevel.Index].Text = level.ToString();

                    var lodInfo = ActiveTarget.LodInfoArray[level];

                    // プリミティブ
                    item.SubItems[clhPolygonCount.Index].Text = lodInfo.PolygonCount.ToString();

                    // 頂点数
                    item.SubItems[clhVertexCount.Index].Text = lodInfo.VertexCount.ToString();

                    // 処理頂点数
                    item.SubItems[clhProcessVertexCount.Index].Text = lodInfo.HasProcessVertexCount ? lodInfo.ProcessVertexCount.ToString() : res.Strings.ProcessVertexCount_UnsupportedPlatform;

                    // トライアングルごとの処理頂点数
                    item.SubItems[clhProcessVertexCountPerTriangle.Index].Text = lodInfo.HasProcessVertexCount ? lodInfo.ProcessVertexCountPerTriangle.ToString() : res.Strings.ProcessVertexCount_UnsupportedPlatform;
                }

                if (levelCount > 1)
                {
                    ListViewItem item = lvwLod.Items[levelCount];

                    // LOD レベル
                    item.SubItems[clhLevel.Index].Text = res.Strings.ModelPropertyPage_Sum;

                    // プリミティブ
                    var polygonSum = ActiveTarget.LodInfoArray.Sum(x => x.PolygonCount);
                    item.SubItems[clhPolygonCount.Index].Text = polygonSum.ToString();

                    // 頂点数
                    var vertexSum = ActiveTarget.LodInfoArray.Sum(x => x.VertexCount);
                    item.SubItems[clhVertexCount.Index].Text = vertexSum.ToString();

                    // 処理頂点数を持っているかどうか。
                    // 持っていない場合は処理頂点関連の値を表示しない。
                    bool hasProcessVertexCount = ActiveTarget.LodInfoArray.All(x => x.HasProcessVertexCount);

                    // 処理頂点数
                    var processVertexSum = ActiveTarget.LodInfoArray.Sum(x => x.ProcessVertexCount);
                    item.SubItems[clhProcessVertexCount.Index].Text = hasProcessVertexCount ? processVertexSum.ToString() : res.Strings.ProcessVertexCount_UnsupportedPlatform;

                    // トライアングルごとの処理頂点数
                    float totalProcessVertexCountPerTriangle = polygonSum != 0 ? (float)processVertexSum / polygonSum : 0f;
                    item.SubItems[clhProcessVertexCountPerTriangle.Index].Text = hasProcessVertexCount ? totalProcessVertexCountPerTriangle.ToString() : res.Strings.ProcessVertexCount_UnsupportedPlatform;
                }

                //lvwLod.SetSelectedItem(ActiveTarget.PreviewLodLevel);
            }
        }

        private void lvwLod_ItemSelectionChanged(object sender, ListViewItemSelectionChangedEventArgs e)
        {

        }
    }
}
