﻿using System;
using App.Command;
using App.Controls;
using App.Data;
using ConfigCommon;

namespace App.PropertyEdit
{
    public partial class ModelGeneralPage : ModelPropertyPage
    {
        public ModelGeneralPage() :
            base(PropertyPageID.ModelGeneral)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_model_property_window_general_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new ModelGeneralPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            // モデル情報
            {
                lblMaterialCount.IsModified = ActiveTarget.Materials.Count != ActiveTarget.savedMaterialCount;
                ltbMaterialCount.Text = ActiveTarget.Materials.Count.ToString();

                lblBoneCount.IsModified = ActiveTarget.Data.skeleton.bone_array.bone.Length != ActiveTarget.savedBoneCount;
                ltbBoneCount.Text = ActiveTarget.HasSkelton ? ActiveTarget.Data.skeleton.bone_array.bone.Length.ToString() : "0";

                lblShapeCount.IsModified = ActiveTarget.Shapes.Count != ActiveTarget.savedShapeCount;
                ltbShapeCount.Text = ActiveTarget.Shapes.Count.ToString();

                cbxUnitePosQuantize.IsModified = ActiveTarget.IsModelInfoValueChanged(x => x.unite_pos_quantize);
                cbxUnitePosQuantize.Checked = ActiveTarget.Data.model_info.unite_pos_quantize;
            }

            // 頂点情報(レベル0)
            {
                bool anyLodInfo = ActiveTarget.LodInfoArray.Length > 0;

                // 処理頂点数関連項目は、選択プラットフォーム毎に数値が変化することがあるで、変更フラグの対象外とする。
                // lblProcessVertexCount.IsModified = ActiveTarget.IsLodInfo0ValueChanged(x => x.ProcessVertexCount);
                ltbProcessVertexCount.Text = (anyLodInfo && ActiveTarget.LodInfoArray[0].HasProcessVertexCount) ? ActiveTarget.LodInfoArray[0].ProcessVertexCount.ToString(): res.Strings.ProcessVertexCount_UnsupportedPlatform;

                // 処理頂点数関連項目は、選択プラットフォーム毎に数値が変化することがあるで、変更フラグの対象外とする。
                // lblProcessVertexPerTriangleCount.IsModified = ActiveTarget.IsLodInfo0ValueChanged(x => x.ProcessVertexCountPerTriangle);
                ltbProcessVertexPerTriangleCount.Text = (anyLodInfo && ActiveTarget.LodInfoArray[0].HasProcessVertexCount) ? ActiveTarget.LodInfoArray[0].ProcessVertexCountPerTriangle.ToString(): res.Strings.ProcessVertexCount_UnsupportedPlatform;

                lblVertexCount.IsModified = ActiveTarget.IsLodInfo0ValueChanged(x => x.VertexCount);
                ltbVertexCount.Text = anyLodInfo ? ActiveTarget.LodInfoArray[0].VertexCount.ToString(): string.Empty;

                lblPolygonCount.IsModified = ActiveTarget.IsLodInfo0ValueChanged(x => x.PolygonCount);
                ltbPolygonCount.Text = anyLodInfo ? ActiveTarget.LodInfoArray[0].PolygonCount.ToString(): string.Empty;
            }

            // スキニング情報
            {
                lblSmoothSkinning.IsModified = ActiveTarget.SmoothSkinningCount != ActiveTarget.savedSmoothSkinningCount;
                ltbSmoothSkinningCount.Text = ActiveTarget.SmoothSkinningCount.ToString();

                lblRigidSkinning.IsModified = ActiveTarget.RigidSkinningCount != ActiveTarget.savedRigidSkinningCount;
                ltbRigidSkinningCount.Text = ActiveTarget.RigidSkinningCount.ToString();

                lblRigidBody.IsModified = ActiveTarget.RigidBodyCount != ActiveTarget.savedRigidBodyCount;
                ltbRigidBodyCount.Text = ActiveTarget.RigidBodyCount.ToString();

                cbxUseScale.IsModified = ActiveTarget.IsSkeletonInfoValueChanged(x => x.scale_enable);
                cbxUseScale.Checked = ActiveTarget.HasSkelton ? ActiveTarget.Data.skeleton.skeleton_info.scale_enable : false;
                cbxUseScale.Enabled = ActiveTarget.HasSkelton;

                lblScaleMode.IsModified = ActiveTarget.IsSkeletonInfoValueChanged(x => x.scale_mode);
                ltbScaleMode.Text = ActiveTarget.HasSkelton ? UIText.EnumValue(ActiveTarget.Data.skeleton.skeleton_info.scale_mode) : string.Empty;

                lblRotateMode.IsModified = ActiveTarget.IsSkeletonInfoValueChanged(x => x.rotate_mode);
                ltbRotateMode.Text = ActiveTarget.HasSkelton ? UIText.EnumValue(ActiveTarget.Data.skeleton.skeleton_info.rotate_mode) : string.Empty;

                cbxUseMotionMirroring.IsModified = ActiveTarget.IsSkeletonInfoValueChanged(x => x.motion_mirroring_enable);
                cbxUseMotionMirroring.Checked = ActiveTarget.HasSkelton ? ActiveTarget.Data.skeleton.skeleton_info.motion_mirroring_enable : false;
                cbxUseMotionMirroring.Enabled = ActiveTarget.HasSkelton;
            }

            // DCC
            {
                lblDccPreset.IsModified = ActiveTarget.IsModelInfoStringChanged(x => x.dcc_preset);
                ltbDccPreset.Text = ActiveTarget.Data.model_info.dcc_preset;

                lblDccMagnify.IsModified = ActiveTarget.IsModelInfoValueChanged(x => x.dcc_magnify);
                ltbDccMagnify.Text = ActiveTarget.Data.model_info.dcc_magnify.ToString();

                lblDccStartFrame.IsModified = ActiveTarget.IsModelInfoValueChanged(x => x.dcc_start_frame);
                ltbDccStartFrame.Text = ActiveTarget.Data.model_info.dcc_start_frame.ToString();
            }
        }

        public static bool IsModified(Model activeTarget)
        {
            return activeTarget != null &&
                (activeTarget.Materials.Count != activeTarget.savedMaterialCount ||
                activeTarget.Data.skeleton.bone_array.bone.Length != activeTarget.savedBoneCount ||
                activeTarget.Shapes.Count != activeTarget.savedShapeCount ||
                activeTarget.IsModelInfoValueChanged(x => x.unite_pos_quantize) ||
                // 処理頂点数関連項目は、選択プラットフォーム毎に数値が変化することがあるで、変更フラグの対象外とする。
                // ActiveTarget.IsLodInfo0ValueChanged(x => x.ProcessVertexCount) ||
                // ActiveTarget.IsLodInfo0ValueChanged(x => x.ProcessVertexCountPerTriangle) ||
                activeTarget.IsLodInfo0ValueChanged(x => x.VertexCount) ||
                activeTarget.IsLodInfo0ValueChanged(x => x.PolygonCount) ||
                activeTarget.SmoothSkinningCount != activeTarget.savedSmoothSkinningCount ||
                activeTarget.RigidSkinningCount != activeTarget.savedRigidSkinningCount ||
                activeTarget.RigidBodyCount != activeTarget.savedRigidBodyCount ||
                activeTarget.IsSkeletonInfoValueChanged(x => x.scale_enable) ||
                activeTarget.IsSkeletonInfoValueChanged(x => x.scale_mode) ||
                activeTarget.IsSkeletonInfoValueChanged(x => x.rotate_mode) ||
                activeTarget.IsSkeletonInfoValueChanged(x => x.motion_mirroring_enable) ||
                activeTarget.IsModelInfoStringChanged(x => x.dcc_preset) ||
                activeTarget.IsModelInfoValueChanged(x => x.dcc_magnify) ||
                activeTarget.IsModelInfoValueChanged(x => x.dcc_start_frame));
        }

        private void cbxUseScale_CheckedChanged(object sender, EventArgs e)
        {
            bool scaleEnable = (bool)((UICheckBox)sender).Checked;

            TheApp.CommandManager.Execute(CreateEditCommand_skeleton_info_scale_enable(Targets, scaleEnable));
        }

        private void cbxUseMotionMirroring_CheckedChanged(object sender, EventArgs e)
        {
            bool motionMirroringEnable = (bool)((UICheckBox)sender).Checked;

            TheApp.CommandManager.Execute(CreateEditCommand_skeleton_info_motion_mirroring_enable(Targets, motionMirroringEnable));
        }

        private void cbxUnitePosQuantize_CheckedChanged(object sender, EventArgs e)
        {
            bool unitePosQuantizeEnable = (bool)((UICheckBox)sender).Checked;

            TheApp.CommandManager.Execute(CreateEditCommand_model_info_unite_pos_quantize(Targets, unitePosQuantizeEnable));
        }

        static private GroupEditCommand CreateEditCommand_skeleton_info_scale_enable(GuiObjectGroup targets, bool scaleEnable)
        {
            return
                 new GeneralGroupValueEditCommand<bool>(
                    targets,
                    GuiObjectID.Model,
                    scaleEnable,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        Model model = target as Model;

                        swap = model.Data.skeleton.skeleton_info.scale_enable;
                        model.Data.skeleton.skeleton_info.scale_enable = (bool)data;

                        Viewer.LoadOrReloadModel.Send(model);
                    },
                    postEditDelegate : (editTargets, data) =>
                    {
                    }
                );
        }

        static private GroupEditCommand CreateEditCommand_skeleton_info_motion_mirroring_enable(GuiObjectGroup targets, bool motionMirroringEnable)
        {
            return
                 new GeneralGroupValueEditCommand<bool>(
                    targets,
                    GuiObjectID.Model,
                    motionMirroringEnable,
                    delegate (ref GuiObject target, ref object data, ref object swap)
                    {
                        Model model = target as Model;

                        swap = model.Data.skeleton.skeleton_info.motion_mirroring_enable;
                        model.Data.skeleton.skeleton_info.motion_mirroring_enable = (bool)data;

                        Viewer.LoadOrReloadModel.Send(model);
                    },
                    postEditDelegate: (editTargets, data) =>
                    {
                    }
                );
        }

        static private GroupEditCommand CreateEditCommand_model_info_unite_pos_quantize(GuiObjectGroup targets, bool unitePosQuantizeEnable)
        {
            return
                 new GeneralGroupValueEditCommand<bool>(
                    targets,
                    GuiObjectID.Model,
                    unitePosQuantizeEnable,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        Model model = target as Model;

                        swap = model.Data.model_info.unite_pos_quantize;
                        model.Data.model_info.unite_pos_quantize = (bool)data;

                        Viewer.LoadOrReloadModel.Send(model);
                    },
                    postEditDelegate : (editTargets, data) =>
                    {
                    }
                );
        }

        #region コピー＆ペースト
        private class CopyData
        {
            public bool unitePosQuantizeEnable { get; set; }
            public bool skeleton_info_scale_enable { get; set; }
            public bool skeleton_info_motion_mirroring_enable { get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return true;
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(Model target)
        {
            return
                new CopyData()
                {
                    unitePosQuantizeEnable = target.Data.model_info.unite_pos_quantize,
                    skeleton_info_scale_enable = target.Data.skeleton.skeleton_info.scale_enable,
                    skeleton_info_motion_mirroring_enable = target.Data.skeleton.skeleton_info.motion_mirroring_enable,
                };
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            var commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(CreateEditCommand_model_info_unite_pos_quantize(targets, copyData.unitePosQuantizeEnable));
                commandSet.Add(CreateEditCommand_skeleton_info_scale_enable(targets, copyData.skeleton_info_scale_enable));
                commandSet.Add(CreateEditCommand_skeleton_info_motion_mirroring_enable(targets, copyData.skeleton_info_motion_mirroring_enable));
            }
            return commandSet.Execute();
        }
        #endregion
    }
}
