﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using App.Controls;
using App.Data;
using App.res;
using App.Utility;
using System.Text.RegularExpressions;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit.ShaderParamControls
{
    public class EditRenderInfoBase : ShaderParamControl
    {
        public virtual bool SetValues(Material material, List<string> values, bool candidateModified, CustomUI customUI, Definition.ShadingModelTable table, Predicate<string> visibleGroups, HashSet<string> visiblePages, bool showId, bool showOriginalLabel, Material.ValueResolvedState valueResolvedState)
        {
            throw new NotImplementedException();
        }

        public static Color GetBgColor(bool candidateModified, bool packFromHio, bool hasRange)
        {
            Color bgColor;

            if (packFromHio) // ビューアから選択肢が送られてきている
            {
                if (candidateModified) bgColor = ModifiedColor;
                else bgColor = EditedColor;
            }
            else if (hasRange) // シェーダー定義から選択肢が取得できた
            {
                bgColor = SfdDefinedColor;
            }
            else //
            {
                bgColor = SfdNonDefinedColor;
            }
            return bgColor;
        }

        public static Color ModifiedColor = Color.PeachPuff;
        public static Color EditedColor = Color.LightBlue;
        public static Color SfdDefinedColor = Color.LightGoldenrodYellow;
        public static Color SfdNonDefinedColor = Color.LightGray;// Color.Gainsboro;

        public override ParamType ParamType
        {
            get { return ShaderParamControls.ParamType.render_info_slot; }
        }

        public override void UpdateLabel()
        {
            // テキストブロックは終端のコロンを外す
            bool colon = true;
            if (this is EditRenderInfo)
            {
                colon = !((EditRenderInfo)this).IsTextBlock;
            }

            lblParameter.Text = labelHelper.GetLabelString(colon);
            lblParameter.ForeColor = labelHelper.color ?? SystemColors.ControlText;
            // 背景色は無視
            UpdateDropDownButtonLocation();
            UpdateLinkToolTip(false);
        }
    }
}
