﻿using System.Drawing;
using System.Windows.Forms;
using App.Controls;
using App.Data;
using App.Utility;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class MaterialOriginalInfoPage : MaterialPropertyPage
    {
        public MaterialOriginalInfoPage() :
            base(PropertyPageID.MaterialOriginalInfo)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_material_property_window_original_information_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new MaterialOriginalInfoPage();
        }

        protected override void InitializeFormInternal()
        {
            lvwTexSrt.CustomDrawItem += (sender, e) =>
            {
            };

            lvwColor.CustomDrawItem += (sender, e) =>
            {
                if (e.ColumnIndex == 2 && e.SubItem.Tag is RgbaColor)
                {
                    Rectangle rcColor = e.Bounds;
                    rcColor.Inflate(-2, -2);
                    rcColor.Width = rcColor.Height;

                    var color = (RgbaColor)e.SubItem.Tag;

                    using (SolidBrush brush = new SolidBrush(color.ToColorNoAlpha()))
                    {
                        e.Graphics.FillRectangle(brush, rcColor);
                        GraphicsUtility.DrawRectangle(e.Graphics, (color.R == 1 && color.G == 1 && color.B == 1) ? Pens.DimGray : Pens.Black, rcColor);
                    }

                    // 成分値
                    Rectangle rcValue = new Rectangle(rcColor.Right + 2, e.Bounds.Y, e.Bounds.Width - (2 + rcColor.Width + 2), e.Bounds.Height);
                    using (StringFormat sf = new StringFormat())
                    {
                        sf.Alignment = StringAlignment.Near;
                        sf.LineAlignment = StringAlignment.Center;
                        sf.Trimming = StringTrimming.None;
                        sf.FormatFlags |= StringFormatFlags.NoWrap;

                        // カラー
                        Color textColor = SystemColors.WindowText;
                        if (e.IsSelected && e.IsFocused)
                        {
                            textColor = SystemColors.HighlightText;
                        }

                        // テキスト
                        using (Brush brush = new SolidBrush(textColor))
                        {
                            string text = string.Empty;
                            text = string.Format("{0:F3}, {1:F3}, {2:F3}", color.R, color.G, color.B);
                            e.Graphics.DrawString(text, Font, brush, rcValue, sf);
                        }
                    }

                    // 処理しました
                    e.Handled = true;
                }
                else
                {
                    //e.DrawDefault();
                }

            };
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            var orgMtl = ActiveTarget.originalMaterial;
            if (orgMtl == null)
            {
                //return;
            }

            using (var ub = new UpdateBlock(lvwColor))
            {
                if (orgMtl == null || orgMtl.original_color_array == null)
                {
                    lvwColor.SetItemCount(0);
                }
                else
                {
                    lvwColor.SetItemCount(orgMtl.original_color_array.original_color.Length);
                    int index = 0;
                    foreach (var color in orgMtl.original_color_array.original_color)
                    {
                        ListViewItem item = lvwColor.Items[index];
                        item.Tag = color;

                        // インデックス
                        item.SubItems[clhOrigColorIndex.Index].Text = index.ToString();

                        // hint
                        item.SubItems[clhColorHint.Index].Text = color.hint;

                        // カラー
                        var tagColor = new RgbaColor(color.color[0], color.color[1], color.color[2], 1.0f);
                        item.SubItems[clhColor.Index].Tag = tagColor;

                        index++;
                    }
                }
            }

            if (lvwColor.SelectedIndex == -1 && lvwColor.Items.Count > 0)
            {
                lvwColor.SetSelectedItem(0);
            }

            using (var ub = new UpdateBlock(lvwTexSrt))
            {
                if (orgMtl == null || orgMtl.original_texsrt_array == null)
                {
                    lvwTexSrt.SetItemCount(0);
                }
                else
                {
                    lvwTexSrt.SetItemCount(orgMtl.original_texsrt_array.original_texsrt.Length);
                    int index = 0;
                    foreach (var texsrt in orgMtl.original_texsrt_array.original_texsrt)
                    {
                        ListViewItem item = lvwTexSrt.Items[index];
                        item.Tag = texsrt;

                        // インデックス
                        item.SubItems[clhOrigTexSrtIndex.Index].Text = index.ToString();

                        // hint
                        item.SubItems[clhTexSrtHint.Index].Text = texsrt.hint;

                        // uv_hint
                        item.SubItems[clhTexSrtUvHint.Index].Text = texsrt.uv_hint;

                        // mode
                        string modestr = "";

                        if (texsrt.mode == original_texsrt_modeType.maya)
                        {
                            modestr = "maya";
                        }
                        else if (texsrt.mode == original_texsrt_modeType.Item3dsmax)
                        {
                            modestr = "3dsmax";
                        }
                        else if (texsrt.mode == original_texsrt_modeType.softimage)
                        {
                            modestr = "softimage";
                        }
                        item.SubItems[clhTexSrtMode.Index].Text = modestr;

                        // scale
                        item.SubItems[clhScale.Index].Text = string.Format("{0:F3}, {1:F3}", texsrt.scale[0], texsrt.scale[1]);

                        // rotate
                        item.SubItems[clhRotate.Index].Text = texsrt.rotate.ToString("F3");

                        // trans
                        item.SubItems[clhTrans.Index].Text = string.Format("{0:F3}, {1:F3}", texsrt.translate[0], texsrt.translate[1]);

                        index++;
                    }
                }
            }

            if (lvwTexSrt.SelectedIndex == -1 && lvwTexSrt.Items.Count > 0)
            {
                lvwTexSrt.SetSelectedItem(0);
            }
        }


        #region コマンド
        #endregion

        #region コピー＆ペースト
        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return false;
        }

        #endregion
    }

}
