﻿using System;
using System.Collections;
using System.Diagnostics;
using System.Linq;
using App.Command;
using App.Data;
using ConfigCommon;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public partial class BoneGeneralPage : BonePropertyPage
    {
        public BoneGeneralPage() :
            base(PropertyPageID.BoneGeneral)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_bone_property_window_general_page;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new BoneGeneralPage();
        }

        protected override void InitializeFormInternal()
        {
            rbaBillboard.SetRadioButton(rbtBillboardNone, bone_billboardType.none, UIText.EnumValue(bone_billboardType.none));
            rbaBillboard.SetRadioButton(rbtBillboardWorld, bone_billboardType.world_viewvector, UIText.EnumValue(bone_billboardType.world_viewvector));
            rbaBillboard.SetRadioButton(rbtBillboardWorldViewpoint, bone_billboardType.world_viewpoint, UIText.EnumValue(bone_billboardType.world_viewpoint));
            rbaBillboard.SetRadioButton(rbtBillboardScreen, bone_billboardType.screen_viewvector, UIText.EnumValue(bone_billboardType.screen_viewvector));
            rbaBillboard.SetRadioButton(rbtBillboardScreenViewpoint, bone_billboardType.screen_viewpoint, UIText.EnumValue(bone_billboardType.screen_viewpoint));
            rbaBillboard.SetRadioButton(rbtBillboardYaxis, bone_billboardType.yaxis_viewvector, UIText.EnumValue(bone_billboardType.yaxis_viewvector));
            rbaBillboard.SetRadioButton(rbtBillboardYaxisViewpoint, bone_billboardType.yaxis_viewpoint, UIText.EnumValue(bone_billboardType.yaxis_viewpoint));
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            // ボーン情報
            lblBoneIndex.IsModified = ActiveTarget.IsValueChanged(x => x.index);
            ltbBoneIndex.Text = ActiveTarget.Data.index.ToString();

            lblParentName.IsModified = ActiveTarget.IsStringChanged(x => x.parent_name);
            ltbParentName.Text = ActiveTarget.Data.parent_name;

            // ボーン行列
            lblSmoothSkinning.IsModified = ActiveTarget.IsValueChanged(x => x.matrix_index[0]);
            ltbMatrixIndex0.Text = ActiveTarget.Data.matrix_index[0].ToString();

            lblMatrixIndex1.IsModified = ActiveTarget.IsValueChanged(x => x.matrix_index[1]);
            ltbMatrixIndex1.Text = ActiveTarget.Data.matrix_index[1].ToString();

            lblRigidBody.IsModified = ActiveTarget.IsValueChanged(x => x.rigid_body);
            ltbRigidBody.Text = UIText.FlagYesNo(ActiveTarget.Data.rigid_body);

            lblScaleCompensate.IsModified = ActiveTarget.IsValueChanged(x => x.scale_compensate);
            ltbScaleCompensate.Text = UIText.FlagYesNo(ActiveTarget.Data.scale_compensate);

            string format = "F3";
            lblScale.IsModified = ActiveTarget.IsArrayChanged(x => x.scale);
            lblScaleX.Text = ActiveTarget.Data.scale[0].ToString(format);
            lblScaleY.Text = ActiveTarget.Data.scale[1].ToString(format);
            lblScaleZ.Text = ActiveTarget.Data.scale[2].ToString(format);

            // 度表示
            lblRotate.IsModified = ActiveTarget.IsArrayChanged(x => x.rotate);
            lblRotateX.Text = ActiveTarget.Data.rotate[0].ToString(format);
            lblRotateY.Text = ActiveTarget.Data.rotate[1].ToString(format);
            lblRotateZ.Text = ActiveTarget.Data.rotate[2].ToString(format);
            lblRotateW.Text = ActiveTarget.Data.rotate[3].ToString(format);

            lblTranslate.IsModified = ActiveTarget.IsArrayChanged(x => x.translate);
            lblTranslateX.Text = ActiveTarget.Data.translate[0].ToString(format);
            lblTranslateY.Text = ActiveTarget.Data.translate[1].ToString(format);
            lblTranslateZ.Text = ActiveTarget.Data.translate[2].ToString(format);

            // ビルボード
            grpBillboard.IsModified = ActiveTarget.IsValueChanged(x => x.billboard);
            rbaBillboard.SelectedRadioButtonData = ActiveTarget.Data.billboard;
            lblDescription.Text = GetDescriptionText(ActiveTarget.Data.billboard);

            // 可視
            chkVisibility.IsModified = ActiveTarget.IsValueChanged(x => x.visibility);
            chkVisibility.Checked = ActiveTarget.Data.visibility;

            // 圧縮許可
            chkCompress.IsModified = ActiveTarget.IsValueChanged(x => x.compress_enable);
            chkCompress.Checked = ActiveTarget.Data.compress_enable;

            // ボーンサイド
            lblBoneSide.IsModified = ActiveTarget.IsValueChanged(x => x.side);
            ltbBoneSide.Text = ActiveTarget.Data.side.ToString();

            // 表示・非表示
            if (ActiveTarget.Owner.Data.skeleton.skeleton_info.rotate_mode == skeleton_info_rotate_modeType.euler_xyz)
            {
                lblW.Visible = false;
                lblRotateW.Visible = false;
            }
            else
            {
                lblW.Visible = true;
                lblRotateW.Visible = true;
            }

        }

        public static bool IsModified(Bone activeTarget)
        {
            return activeTarget != null &&
                (activeTarget.IsValueChanged(x => x.index) ||
                activeTarget.IsStringChanged(x => x.parent_name) ||
                activeTarget.IsValueChanged(x => x.matrix_index[0]) ||
                activeTarget.IsValueChanged(x => x.matrix_index[1]) ||
                activeTarget.IsValueChanged(x => x.rigid_body) ||
                activeTarget.IsValueChanged(x => x.scale_compensate) ||
                activeTarget.IsArrayChanged(x => x.scale) ||
                activeTarget.IsArrayChanged(x => x.rotate) ||
                activeTarget.IsArrayChanged(x => x.translate) ||
                activeTarget.IsValueChanged(x => x.billboard) ||
                activeTarget.IsValueChanged(x => x.visibility) ||
                activeTarget.IsValueChanged(x => x.compress_enable) ||
                activeTarget.IsValueChanged(x => x.side));
        }

        /// <summary>
        /// 解説テキストを取得。
        /// </summary>
        private string GetDescriptionText(bone_billboardType value)
        {
            switch (value)
            {
                case bone_billboardType.none:
                    return res.Strings.Node_Billboard_Desc_None;
                case bone_billboardType.world_viewvector:
                    return res.Strings.Node_Billboard_Desc_World;
                case bone_billboardType.world_viewpoint:
                    return res.Strings.Node_Billboard_Desc_World_Viewpoint;
                case bone_billboardType.screen_viewvector:
                    return res.Strings.Node_Billboard_Desc_Screen;
                case bone_billboardType.screen_viewpoint:
                    return res.Strings.Node_Billboard_Desc_Screen_Viewpoint;
                case bone_billboardType.yaxis_viewvector:
                    return res.Strings.Node_Billboard_Desc_Yaxis;
                case bone_billboardType.yaxis_viewpoint:
                    return res.Strings.Node_Billboard_Desc_Yaxis_Viewpoint;
                default:
                    Debug.Assert(false);
                    return string.Empty;
            }
        }

        #region コマンド


        private static GroupEditCommand CreateEditCommand_billboard(GuiObjectGroup targets, bone_billboardType type)
        {
            var reloadModels = targets.GetObjects(GuiObjectID.Bone).OfType<Bone>().Where(x => x.Data.billboard == bone_billboardType.none ||
                type == bone_billboardType.none).Select(x => x.Owner).Distinct().ToArray();
            var sendBones = new ArrayList(targets.GetObjects(GuiObjectID.Bone).OfType<Bone>().Where(x => !(x.Data.billboard == bone_billboardType.none ||
                type == bone_billboardType.none)).ToList());
            return
                new GeneralGroupValueEditCommand<bone_billboardType>(
                    targets,
                    GuiObjectID.Bone,
                    type,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        var bone = target as Bone;

                        swap = bone.Data.billboard;
                        bone.Data.billboard = (bone_billboardType)data;
                    },
                    postEditDelegate : (editTargets, data) =>
                    {
                        // ビルボードなし<->ありの切り替え時はリロードを行う。
                        foreach (var model in reloadModels)
                        {
                            Viewer.LoadOrReloadModel.Send(model);
                        }

                        // 2012.04.12 仕様変更により、ReloadModelをやめ、Hio.EditBoneBillboardを呼び出すように修正しました。
                        Viewer.SetBoneBillBoard.Send(
                            sendBones,
                            data,
                            0xFFFFFFFF,
                            0xFFFFFFFF
                        );
                    }
                );
        }

        private static GroupEditCommand CreateEditCommand_visibility(GuiObjectGroup targets, bool visibility)
        {
            return
                new GeneralGroupValueEditCommand<bool>(
                    targets,
                    GuiObjectID.Bone,
                    visibility,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        var bone = target as Bone;

                        swap = bone.Data.visibility;
                        bone.Data.visibility = (bool)data;
                    },
                    postEditDelegate : (editTargets, data) =>
                    {
                        Viewer.SetBoneVisibility.Send(editTargets, data, 0xFFFFFFFF, 0xFFFFFFFF);
                    }
                );
        }

        private static GroupEditCommand CreateEditCommand_compress_enable(GuiObjectGroup targets, bool value)
        {
            return
                new GeneralGroupValueEditCommand<bool>(
                    targets,
                    GuiObjectID.Bone,
                    value,
                    delegate(ref GuiObject target, ref object data, ref object swap)
                    {
                        var bone = target as Bone;

                        swap = bone.Data.compress_enable;
                        bone.Data.compress_enable = (bool)data;
                    }
                );
        }
        #endregion

        #region コピー＆ペースト
        private class CopyData
        {
            public bone_billboardType billboard_type { get; set; }
            public bool bone_visibility { get; set; }
            public bool bone_compress_enable { get; set; }
        }

        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy()
        {
            return true;
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public override object Copy(ref object copyObjectInfo)
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static object Copy(Bone target)
        {
            return
                new CopyData()
                {
                    billboard_type = target.Data.billboard,
                    bone_visibility = target.Data.visibility,
                    bone_compress_enable = target.Data.compress_enable,
                };
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(object pasteObject)
        {
            TheApp.CommandManager.Add(Paste(Targets, pasteObject));
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static ICommand Paste(GuiObjectGroup targets, object pasteObject)
        {
            EditCommandSet commandSet = new EditCommandSet();
            {
                var copyData = (CopyData)pasteObject;

                commandSet.Add(CreateEditCommand_billboard(targets, copyData.billboard_type));
                commandSet.Add(CreateEditCommand_visibility(targets, copyData.bone_visibility));
                commandSet.Add(CreateEditCommand_compress_enable(targets, copyData.bone_compress_enable));
            }

            return commandSet.Execute();
        }
        #endregion

        #region イベント
        private void rbaBillboard_SelectionChanged(object sender, EventArgs e)
        {
            bone_billboardType value = (bone_billboardType)rbaBillboard.SelectedRadioButtonData;
            TheApp.CommandManager.Execute(CreateEditCommand_billboard(Targets, value));
        }

        private void chkVisibility_CheckedChanged(object sender, EventArgs e)
        {
            TheApp.CommandManager.Execute(CreateEditCommand_visibility(Targets, chkVisibility.Checked));
        }

        private void chkCompress_CheckedChanged(object sender, EventArgs e)
        {
            TheApp.CommandManager.Execute(CreateEditCommand_compress_enable(Targets, chkCompress.Checked));
        }
        #endregion
    }
}
