﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Runtime.ExceptionServices;
using System.Threading;
using System.Windows.Forms;

namespace App
{
    // バッググラウンドタスクマネージャー
    static public class BackgroundTaskManager
    {
        private static readonly object syncObject_ = new object();

        private static Thread			thread_	= null;
        private static readonly Queue<Action>	queue_	= new Queue<Action>();

        public static void Initialize()
        {
            thread_ = new Thread(ThreadMain)
            {
                IsBackground = true,
                CurrentCulture = Thread.CurrentThread.CurrentCulture,
                CurrentUICulture = Thread.CurrentThread.CurrentUICulture,
                Priority = ThreadPriority.Lowest
            };

            thread_.Start();
        }

        public static void Destroy()
        {
            // スレッドの停止を待つ
            if (thread_ != null)
            {
                thread_.Abort();
                thread_.Join();
                thread_ = null;
            }
        }

        private static void ThreadMain()
        {
            while (true)
            {
                try
                {
                    Loopmain();
                }
                catch (Exception e)
                {
                    if (e is ThreadAbortException)
                    {
                        // なぜか Debug 版ではここで return しなくても終了した。
                        return;
                    }
                    else
                    {
                        TheApp.MainFrame.InvokeAfterCanFocus(() =>
                        {
                            TheApp.OnFatalErrorOccured(e, false);
                            Environment.Exit(0);
                        });
                    }
                }
            }
        }

        private static void Loopmain()
        {
            Thread.Sleep(1000);

            Action[] tasks = null;
            {
                if (queue_.Count > 0)
                {
                    lock (syncObject_)
                    {
                        tasks = queue_.ToArray();
                        queue_.Clear();
                    }
                }
            }
            if (tasks != null)
            {
                foreach (var task in tasks)
                {
                    task();
                }
            }
        }

        // タスクの追加
        public static void AddTask(Action task)
        {
            lock(syncObject_)
            {
                queue_.Enqueue(task);
            }
        }
    }
}
