﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.Windows.Forms;
using App.Controls;
using nw.g3d.iflib;

namespace App.Data
{
    public class SkeletalAnimationMerger
    {
        public SkeletalAnimation MergeFile(SkeletalAnimation dstAnim, string srcAnimPath, MergerUtility.MergeMode mergeMode)
        {
            using (var block = new App.AppContext.PropertyChangedSuppressBlock())
            using (var vdsb = new Viewer.ViewerDrawSuppressBlock())
            {
                // マージ元アニメーションを読み込む
                var srcAnim = MergerUtility.LoadDocument<SkeletalAnimation>(srcAnimPath);

                // マージダイアログを開いて変換情報を作る
                IfSkeletalAnimMerger.IfSkeletalAnimMergerInfo info = null;

                if(mergeMode != MergerUtility.MergeMode.Auto)
                {
                    using(var dialog = new SkeletalAnimationMergeDialog(dstAnim, srcAnim))
                    {
                        if ((mergeMode == MergerUtility.MergeMode.Manual) || (dialog.IsSame == false))
                        {
                            if (dialog.ShowDialog() != DialogResult.OK)
                            {
                                return null;
                            }
                        }

                        info = new IfSkeletalAnimMerger.IfSkeletalAnimMergerInfo()
                        {
                            IsMergeQuantize		= dialog.IsMergeQuantize,
                            BoneNamePairTable	= dialog.BoneNamePairTable,
                        };
                    }
                }

                // 対象のクローンを作る
                var clonedDstAnim = MergerUtility.CloneDocument(dstAnim);

                // マージする
                {
                    Debug.Assert(clonedDstAnim is SkeletalAnimation);
                    Debug.Assert(srcAnim is SkeletalAnimation);

                    var dstStreams = clonedDstAnim.BinaryStreams;
                    var srcStreams = srcAnim.BinaryStreams;

                    if (info != null)
                    {
                        IfSkeletalAnimMerger.Merge(
                            (clonedDstAnim as SkeletalAnimation).Data, dstStreams,
                            (srcAnim       as SkeletalAnimation).Data, srcStreams,
                            info
                        );
                    }
                    else
                    {
                        IfSkeletalAnimMerger.Merge(
                            (clonedDstAnim as SkeletalAnimation).Data, dstStreams,
                            (srcAnim       as SkeletalAnimation).Data, srcStreams
                        );
                    }

                    // 最適化ログの追加
                    MergerUtility.AddOptimizeLog(clonedDstAnim, clonedDstAnim.Data, srcAnimPath);
                }

                clonedDstAnim.Initialize();

                return clonedDstAnim;
            }
        }
    }
}
