﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.IO;
using System.Linq;
using App.Utility;
using ConfigCommon;

namespace App.Data
{
    // 拡張メソッド
    public static class HasAnimationExtensions
    {
        public static bool CheckNameCollision(this AnimationSet document, string name, GuiObjectID id)
        {
            return !document.Animations.Any(x => Path.GetFileNameWithoutExtension(x.Name) == name && ObjectIDUtility.ExtToId(Path.GetExtension(x.Name)) == id);
        }
    }
}
