﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.ComponentModel;
using System.Windows.Forms;

namespace App.Controls
{
    /// <summary>
    /// ＵＩスプリットコンテナクラス。
    /// </summary>
    public class UISplitContainer : SplitContainer
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UISplitContainer()
        {
            base.TabStop = false;
        }

        /// <summary>
        /// 分割比率。
        /// </summary>
        [Browsable(false)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public float SplitRatio
        {
            get
            {
                // パネル１と全体のサイズを取得
                int totalSize;
                int panelSize;
                if (Orientation == Orientation.Vertical)
                {
                    totalSize = Width - SplitterWidth;
                    panelSize = Panel1.Width;
                }
                else
                {
                    totalSize = Height - SplitterWidth;
                    panelSize = Panel1.Height;
                }

                // パネル１：全体の比率を取得
                if (totalSize > 0)
                {
                    // ズレさせないために 1/100 精度しか計算しない
                    float ratio = panelSize / (float)totalSize;
                    return (int)(ratio * 100 + 0.5f) / 100.0f;
                }
                return 0.0f;
            }
            set
            {
                value = Math.Min(Math.Max(0.0f, value), 1.0f);

                // 全体のサイズを取得
                int totalSize;
                if (Orientation == Orientation.Vertical)
                {
                    totalSize = Width - SplitterWidth;
                }
                else
                {
                    totalSize = Height - SplitterWidth;
                }

                // 比率に応じて分割距離を設定
                if (totalSize > 0)
                {
                    SplitterDistance = Convert.ToInt32(totalSize * value);
                }
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                if (UIControlEventSuppressBlock.Enabled)
                {
                    return false;
                }
                return base.CanRaiseEvents;
            }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [DefaultValue(false)]
        [ReadOnly(true)]
        public new bool TabStop
        {
            get { return base.TabStop; }
            set { base.TabStop = value; }
        }
    }
}
