﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ComponentModel;
using System.Drawing;

namespace App.Controls
{
    /// <summary>
    /// 記号ボタンクラス。
    /// </summary>
    public sealed class SymbolButton : UIButton
    {
        // 記号
        private SymbolButtonSymbol _symbol = SymbolButtonSymbol.Left;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public SymbolButton()
        {
            // 記号用フォントにする
            base.Font = new Font("Marlett", 12.0f, FontStyle.Bold, GraphicsUnit.Point, 2);

            // テキスト更新
            UpdateText();
        }

        /// <summary>
        /// 記号。
        /// </summary>
        [DefaultValue(SymbolButtonSymbol.Left)]
        [RefreshProperties(RefreshProperties.Repaint)]
        [Description("テキストとして表示される記号です。")]
        public SymbolButtonSymbol Symbol
        {
            get { return _symbol;  }
            set
            {
                _symbol = value;

                // テキスト更新
                UpdateText();
            }
        }

        /// <summary>
        /// テキスト更新。
        /// </summary>
        private void UpdateText()
        {
            base.Text = ((int)_symbol).ToString();
        }

        #region デザイナ制御
        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override Font Font
        {
            get { return base.Font;  }
            set { base.Font = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new Image Image
        {
            get { return base.Image;  }
            set { base.Image = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new ContentAlignment ImageAlign
        {
            get { return base.ImageAlign;  }
            set { base.ImageAlign = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        public new int ImageIndex
        {
            get { return base.ImageIndex;  }
            set { base.ImageIndex = value; }
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [ReadOnly(true)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override string Text
        {
            get { return base.Text;  }
            set { base.Text = value; }
        }
        #endregion
    }

    /// <summary>
    /// 記号ボタン用記号。
    /// 文字列化してそのまま使用できる値にしています。
    /// </summary>
    public enum SymbolButtonSymbol
    {
        /// <summary>左。</summary>
        Left = 3,
        /// <summary>右。</summary>
        Right = 4,
        /// <summary>上。</summary>
        Up = 5,
        /// <summary>下。</summary>
        Down = 6,
    }
}
