﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Linq;
using App.Data;
using App.res;

namespace App.Controls
{
    /// <summary>
    /// アニメーション作成ダイアログクラス。
    /// </summary>
    public sealed partial class ProjectCreateDialog : OkCancelDialog
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ProjectCreateDialog()
        {
            InitializeComponent();
            if (DocumentManager.DocumentsWithoutProject.Any())
            {
                chbClose.Checked = false;
            }
            else
            {
                chbClose.Enabled = false;
                chbClose.Checked = false;
            }

            foreach (var model in DocumentManager.Models)
            {
                cmbName.Items.Add(model.Name);
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool OnResultOk()
        {
            // アニメーション名の整合確認
            string name = ProjectName;

            // 空文字
            if (name == string.Empty)
            {
                UIMessageBox.Warning(Strings.ProjectCreateDialog_NameEmpty);
                return false;
            }

            // ファイル名
            if (name.Any(x => System.IO.Path.GetInvalidFileNameChars().Any(y => y == x)))
            {
                UIMessageBox.Warning(string.Format(Strings.IO_Name_Invalid, name));
                return false;
            }

            return true;
        }

        /// <summary>
        /// アニメーション名。
        /// </summary>
        public string ProjectName { get { return cmbName.Text; } }

        /// <summary>
        /// ファイルを閉じるかどうか
        /// </summary>
        public bool CloseFiles { get { return chbClose.Checked; } }
    }
}

