﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.ComponentModel;
using System.Drawing;

namespace App.Controls
{
    /// <summary>
    /// 変更マーク
    /// </summary>
    [ToolboxItem(true)]
    public class ModifiedMark : UIControl
    {
        public static readonly Bitmap StarMark = App.Properties.Resources.Control_Star;

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override Size DefaultSize
        {
            get { return StarMark.Size; }
        }

        public ModifiedMark()
        {
        }

        protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
        {
            e.Graphics.DrawImage(StarMark, 0, 0);
        }
    }
}
