﻿using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using App.Data;
using App.Properties;
using App.Utility;
using nw.g3d.iflib;

namespace App.Controls
{
    public sealed partial class ShaderParameterAnimationMergeDialog : OkCancelDialog
    {
        private readonly ShaderParameterAnimation dstShaderParameterAnimation_;
        private readonly ShaderParameterAnimation srcShaderParameterAnimation_;

        public IEnumerable<IfMergeSrcDstPair> MaterialNamePairTable			{ get{ return mtsMaterial.NameTables;			} }

        public bool IsSame { get { return mtsMaterial.IsSame; } }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ShaderParameterAnimationMergeDialog(ShaderParameterAnimation dstShaderParameterAnimation, ShaderParameterAnimation srcShaderParameterAnimation)
        {
            dstShaderParameterAnimation_ = dstShaderParameterAnimation;
            srcShaderParameterAnimation_ = srcShaderParameterAnimation;

            InitializeComponent();

            DialogUtility.SetHelp(this, HelpUtility.PageKey.p_file_menu_a_mergedialog);

            tbxDstPath.Text = dstShaderParameterAnimation_.FilePath;
            tbxSrcPath.Text = srcShaderParameterAnimation_.FilePath;

            // マテリアル
            {
                mtsMaterial.OrgSrcNames = srcShaderParameterAnimation.Data.original_material_anim_array == null ?
                    new string[0]
                    : srcShaderParameterAnimation.Data.original_material_anim_array.original_material_anim.Select(x => x.mat_name).ToArray();
                mtsMaterial.OrgDstNames = dstShaderParameterAnimation.ShaderParamAnims.Select(x => x.mat_name).ToArray();
                mtsMaterial.TargetImage = Resources.GuiObject_Material;
                mtsMaterial.NameTablesChange += (s, e) => lblMaterialResultCount0.Text = mtsMaterial.NameTablesLength.ToString();
                mtsMaterial.Initialize();
                lblMaterialResultCount1.Text = mtsMaterial.OrgDstNames.Length.ToString();
            }
        }

        private void pctSrcTarget_Paint(object sender, PaintEventArgs e)
        {
            DrawTarget(e.Graphics, srcShaderParameterAnimation_.Name, pctSrcTarget.ClientRectangle);
        }

        private void pctDstTarget_Paint(object sender, PaintEventArgs e)
        {
            DrawTarget(e.Graphics, dstShaderParameterAnimation_.Name, pctDstTarget.ClientRectangle);
        }

        private void DrawTarget(Graphics g, string name, Rectangle bounds)
        {
            // 背景
            g.Clear(BackColor);

            // アイコン
            Rectangle rcIcon = bounds;
            rcIcon.X += 2;
            rcIcon.Y += (bounds.Height - 16) / 2;
            rcIcon.Size = new Size(16, 16);
            g.DrawImage(Resources.GuiObject_ShaderParameterAnimation, rcIcon);

            // テキスト
            Rectangle rcText = bounds;
            RectangleUtility.OffsetLeft(ref rcText, rcIcon.Width + 2);
            using (StringFormat sf = new StringFormat())
            {
                sf.Alignment     = StringAlignment.Near;
                sf.LineAlignment = StringAlignment.Center;
                sf.Trimming      = StringTrimming.EllipsisCharacter;
                sf.FormatFlags  |= StringFormatFlags.NoWrap;

                g.DrawString(name, Font, SystemBrushes.WindowText, rcText, sf);
            }
        }
    }
}
