﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using App.Data;

namespace App.Controls
{
    /// <summary>
    /// シェーダーパラメーターアニメーションの修正選択ダイアログクラス。
    /// </summary>
    public sealed partial class SamplerErrorDialog : OkCancelDialog
    {
        public List<string> Messages = new List<string>();
        public List<Material> Materials = new List<Material>();
        public bool CanFix = false;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public SamplerErrorDialog(DocumentManager.SamplerError[][] errors)
        {
            InitializeComponent();
            lvwFileList.SetItemCount(errors.Length);

            int index = 0;
            // リスト構築
            foreach (var error in errors)
            {
                var builder = new StringBuilder();
                ListViewItem item = lvwFileList.Items[index];
                item.Tag = error;

                item.SubItems[clhModel.Index].Text = error[0].material.OwnerDocument.FileName;
                item.SubItems[clhMaterial.Index].Text = error[0].material.Name;
                item.SubItems[clhItem.Index].Text = error.Length.ToString();

                int fixCount = 0;
                foreach (var errorItem in error)
                {
                    if (errorItem.type == DocumentManager.SamplerError.ErrorType.Duplicated)
                    {
                        builder.AppendLine(
                            string.Format(res.Strings.SamplerErrorDialog_DuplicateHint, errorItem.sampler.name, errorItem.sampler.hint));
                    }
                    else if (errorItem.type == DocumentManager.SamplerError.ErrorType.NotFollowDccRule)
                    {
                        string message;
                        if (string.IsNullOrEmpty(errorItem.sampler.hint))
                        {
                            message = string.Format(res.Strings.SamplerErrorDialog_NoHint, errorItem.sampler.name);
                        }
                        else
                        {
                            message = string.Format(res.Strings.SamplerErrorDialog_DccRule, errorItem.sampler.name, errorItem.sampler.hint);
                            if (!string.IsNullOrEmpty(errorItem.correctedName))
                            {
                                message += string.Format(res.Strings.SamplerErrorDialog_Rename, errorItem.correctedName);
                                CanFix = true;
                                fixCount++;
                            }
                        }
                        builder.AppendLine(message);
                    }
                }

                item.SubItems[clhModify.Index].Text = fixCount.ToString();
                Messages.Add(builder.ToString());
                index++;
            }

            if (!CanFix)
            {
                btnOK.Location = btnCancel.Location;
                btnCancel.Visible = false;
            }
            else
            {
                lblDocumentsTitle.Text += res.Strings.SamplerErrorDialog_Fix;
            }
            btnOK.Enabled = true;
            lvwFileList.SetSelectedItem(0);
        }

        private void lvwFileList_SelectionChanged(object sender, EventArgs e)
        {
            var index = lvwFileList.SelectedIndex;
            if (0 <= index && index < Messages.Count)
            {
                tbxDescription.Text = Messages[index];
            }
            else
            {
                tbxDescription.Text = "";
            }
        }
    }
}
