﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.WindowsAPICodePack.Dialogs;
using App.ConfigData;

namespace App.Controls
{
    public partial class FileIoStartUpPathDialog : OkCancelDialog
    {
        /// <summary>
        /// Tag に設定するデータ
        /// </summary>
        public class TagData
        {
            public ConfigCommon.StartUp StartUp;
            public IReadOnlyList<TeamConfig.FileIo.SearchPath> SearchPaths;

            public TagData(ConfigCommon.StartUp startUp, IReadOnlyList<TeamConfig.FileIo.SearchPath> searchPaths)
            {
                StartUp = startUp;
                SearchPaths = searchPaths;
            }
        }

        const int EM_SETCUEBANNER = 0x1500 + 1;

        private List<Func<bool>> acceptable = new List<Func<bool>>();

        public FileIoStartUpPathDialog()
        {
            InitializeComponent();
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            // 入力必須項目に設定。
            if (tbxStartUpPath.IsHandleCreated)
            {
                var ptr = System.Runtime.InteropServices.Marshal.StringToBSTR(App.res.Strings.MandatoryField);
                Win32.NativeMethods.SendMessage(tbxStartUpPath.Handle, EM_SETCUEBANNER, IntPtr.Zero, ptr);
                acceptable.Add(() => { return !string.IsNullOrEmpty(tbxStartUpPath.Text); });
            }

            var data = (TagData)Tag;
            tbxStartUpPath.Text = data.StartUp.pathXml;
            tbxStartUpPathBase.Text = data.StartUp.Base;
        }

        protected override void OnClosing(CancelEventArgs e)
        {
            base.OnClosing(e);

            // e.Cancel 操作は base.OnClosing() 後に行う必要がある。
            if ((DialogResult == DialogResult.OK) && !acceptable.All(x => x()))
            {
                e.Cancel = true;
            }
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // 変更を適用。
            if (DialogResult == DialogResult.OK)
            {
                // null 文字から空文字への変更を回避。
                Func<string, string, string> CorrectString = (oldValue, newValue) =>
                {
                    return ((oldValue == null) && string.IsNullOrEmpty(newValue)) ? null : newValue;
                };

                var data = (TagData)Tag;
                data.StartUp.pathXml = CorrectString(data.StartUp.pathXml, tbxStartUpPath.Text);
                data.StartUp.Base = CorrectString(data.StartUp.Base, tbxStartUpPathBase.Text);
            }
        }

        private void btnStartUpPath_Click(object sender, EventArgs e)
        {
            using (var dialog = new FolderOrFileBrowserDialog()
            {
                Description = res.Strings.IO_SpecifyStartUpPath,
                IncludeFiles = true
            })
            {
                try
                {
                    // StartUp.FullPath() 呼び出しのために一時オブジェクトを作成する。
                    var startUp = new ConfigCommon.StartUp()
                    {
                        Base = !string.IsNullOrEmpty(tbxStartUpPathBase.Text) ? tbxStartUpPathBase.Text : null,
                        pathXml = !string.IsNullOrEmpty(tbxStartUpPath.Text) ? tbxStartUpPath.Text : null
                    };

                    var initPath = startUp.FullPath(((TagData)Tag).SearchPaths);
                    if (!string.IsNullOrEmpty(initPath))
                    {
                        // 期待通りに動作させるにはディレクトリセパレータを正しておく必要がある。
                        dialog.SelectedPath = initPath.Replace(System.IO.Path.AltDirectorySeparatorChar, System.IO.Path.DirectorySeparatorChar);
                    }
                }
                catch
                { }

                if (dialog.ShowDialog(this) == DialogResult.OK)
                {
                    tbxStartUpPath.Text = dialog.SelectedPath;
                }
            }
        }
    }
}
