﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Windows.Forms;
using App.Utility;
using nw.g3d.nw4f_3dif;

namespace App.Controls
{
    public class ColorComponentSelectButton : UICheckBox
    {
        private texture_info_comp_selValue[] value_;
        public texture_info_comp_selValue[] Value
        {
            get{
                return value_;
            }
            set
            {
                value_ = value;
                Invalidate();
            }
        }

        public event EventHandler PopupClose = null;
        public bool IsChangeValue{ get; private set; }

        public ColorComponentSelectButton()
        {
            Appearance = Appearance.Button;
        }

        private int arrow_size = 3;
        private int arrow_edge_size = 4;

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            const int edge = 5;

            var color_rect =
                new Rectangle(
                    ClientRectangle.Left + edge,
                    ClientRectangle.Top  + edge,
                    ClientRectangle.Width  - edge * 2 - (arrow_size + arrow_edge_size) * 2,
                    ClientRectangle.Height - edge * 2 - 1
                );

            ColorComponentSelectCommon.DrawColor(e.Graphics, color_rect, Value, true);

            // ���
            DrawArrow(
                e.Graphics,
                new Rectangle(
                    color_rect.Right + arrow_edge_size + arrow_size,
                    ClientRectangle.Top	+ edge,
                    arrow_size + arrow_edge_size,
                    ClientRectangle.Height - edge * 2
                )
            );
        }

        private void DrawArrow(Graphics g, Rectangle rect)
        {
            Point[] vtx = {
                new Point(rect.Left  - 2, (rect.Top + rect.Bottom) / 2 - 1),
                new Point(rect.Right - 2, (rect.Top + rect.Bottom) / 2 - 1),
                new Point((rect.Left + rect.Right) / 2 - 2, (rect.Top + rect.Bottom) / 2 + arrow_size)
            };

            g.SmoothingMode = SmoothingMode.Default;
            g.FillPolygon(Enabled ? Brushes.Black : Brushes.Gray, vtx);
        }

        private class Popup : ToolStripDropDown
        {
            private readonly ColorComponentSelectButtonPopup	picker_;
            private readonly ToolStripControlHost			host_;

            public bool IsChangeValue
            {
                get
                {
                    return
                        (picker_.ClosedButton == ColorComponentSelectButtonPopup.ButtonType.Ok) &&
                        (OrgValue.SequenceEqual(Value) == false);
                }
            }
            public texture_info_comp_selValue[] Value { get { return picker_.Value; } }
            public texture_info_comp_selValue[] OrgValue { get { return picker_.OrgValue; } }

            public Popup(texture_info_comp_selValue[] srcValue)
            {
                picker_ = new ColorComponentSelectButtonPopup(srcValue, this);
                host_	= new ToolStripControlHost(picker_);

                AutoSize		= true;
                DoubleBuffered	= true;
                ResizeRedraw	= true;

                Padding = Margin = host_.Padding = host_.Margin = Padding.Empty;
                MinimumSize = picker_.MinimumSize;
                picker_.MinimumSize = picker_.Size;
                MaximumSize = new Size(picker_.Size.Width + 1, picker_.Size.Height + 1);
                picker_.MaximumSize = new Size(picker_.Size.Width + 1, picker_.Size.Height + 1);
                Size = new Size(picker_.Size.Width + 1, picker_.Size.Height + 1);

                picker_.Location = Point.Empty;

                Items.Add(host_);
            }
        }

        private Popup popup_ = null;

        protected override void OnClick(EventArgs e){

            base.OnClick(e);

            IsChangeValue = false;

            if(popup_ != null){
                popup_.Dispose();
                popup_ = null;
            }

            Enabled = false;
            Refresh();

            popup_ = new Popup(Value);
            popup_.Closed += (s, a) =>
            {
                Checked = false;
                Enabled = true;
                IsChangeValue = popup_.IsChangeValue;
                Value = ObjectUtility.Clone(popup_.Value);

                if (IsChangeValue == false)
                {
                    Value = popup_.OrgValue;	// ��Ƃɖ߂�
                }

                if(PopupClose != null)
                {
                    PopupClose(this, EventArgs.Empty);
                }

                Invalidate();
            };

            Rectangle rect = Parent.RectangleToScreen(Bounds);

            popup_.Show(new System.Drawing.Point(rect.Left, rect.Bottom));
        }
    }
}
