﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "G3dHioLibDefs.h"

#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class LoadTextureCommand : public EditCommand
{
public:
    LoadTextureCommand(TargetEndianKind targetEndian, IEditTextureTarget^ target, FileData^ fileData)
        : EditCommand(targetEndian)
        , m_FileData(gcnew FileData())
        , m_Target(target)
    {
        m_FileData->Alignment = fileData->Alignment;
        m_FileData->FileName = dynamic_cast<System::String^>(fileData->FileName->Clone());
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

protected:
    virtual bool CanProcessImpl() override
    {
        return m_Target->ResFileKey == 0;
    }

private:
    initonly FileData^ m_FileData;
    initonly IEditTextureTarget^ m_Target;
};

private ref class ReloadTextureCommand : public EditCommand
{
public:
    ReloadTextureCommand(TargetEndianKind targetEndian, IEditTextureTarget^ target, FileData^ fileData)
        : EditCommand(targetEndian)
        , m_FileData(gcnew FileData())
        , m_Target(target)
    {
        m_FileData->Alignment = fileData->Alignment;
        m_FileData->FileName = dynamic_cast<System::String^>(fileData->FileName->Clone());
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

protected:
    virtual bool CanProcessImpl() override
    {
        return m_Target->ResFileKey > 0;
    }

private:

    initonly FileData^ m_FileData;
    initonly IEditTextureTarget^ m_Target;
};

private ref class UnloadTextureCommand : public EditCommand
{
public:
    UnloadTextureCommand(TargetEndianKind targetEndian, IEditTextureTarget^ target)
        : EditCommand(targetEndian)
        , m_Target(target)
    {
        m_ReservedResFileKey = target->ResFileKey;
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

    virtual void OnRemoved() override
    {
        m_Target->ResetStatus();
    }

protected:
    virtual bool CanProcessImpl() override
    {
        return m_ReservedResFileKey > 0;
    }

private:
    UINT32 m_ReservedResFileKey;
    initonly IEditTextureTarget^ m_Target;
};

private ref class BindTextureCommandBase abstract: public EditCommand
{
public:
    BindTextureCommandBase(TargetEndianKind targetEndian, System::UInt32 bindTargetKey, array<IEditTextureTarget^>^ textures)
        : EditCommand(targetEndian)
        , m_BindTargetKey(bindTargetKey)
        , m_Textures(gcnew array<IEditTarget^>(textures->Length))
    {
        System::Array::Copy(textures, m_Textures, textures->Length);
    }

protected:
    bool MakeCommandPacketImpl(nn::g3d::viewer::detail::CommandFlag commandFlag);

private:
    initonly System::UInt32 m_BindTargetKey;
    initonly array<IEditTarget^>^ m_Textures;
};

private ref class BindTextureCommand : public BindTextureCommandBase
{
public:
    BindTextureCommand(TargetEndianKind targetEndian, IEditTarget^ bindTarget, array<IEditTextureTarget^>^ textures)
        : BindTextureCommandBase(targetEndian, bindTarget->ResFileKey, textures)
    {
    }

    BindTextureCommand(TargetEndianKind targetEndian, IEditModelTarget^ bindTarget, array<IEditTextureTarget^>^ textures)
        : BindTextureCommandBase(targetEndian, bindTarget->ModelObjKey, textures)
    {
    }

    virtual bool MakeCommandPacket() override;
};

}}} // namespace NintendoWare.G3d.Edit
