﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "TextureCommand.h"
#include "CommandMaker.h"
#include "TextureCommandMaker.h"
#include <nn/nn_Assert.h>

using namespace nw::g3d::edit::detail;
using namespace System::Collections::Generic;

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool LoadTextureCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(m_FileData->FileName);
    G3D_HTC_THROW_EXCEPTION_UNLESS(packetSize > 0, "Failed to calculate packet size");

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_LOAD_FILE_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_TEXTURE,
        m_Target->Key,
        0,
        m_FileData,
        TargetEndian);
}

bool ReloadTextureCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(m_FileData->FileName);
    G3D_HTC_THROW_EXCEPTION_UNLESS(packetSize > 0, "Failed to calculate packet size");

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_RELOAD_FILE_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_TEXTURE,
        m_Target->Key,
        m_Target->ResFileKey,
        m_FileData,
        TargetEndian);
}

bool UnloadTextureCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(System::String::Empty);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    FileData^ fileData = gcnew FileData();
    fileData->Alignment = 0;
    fileData->FileName = System::String::Empty;

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_UNLOAD_FILE_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_TEXTURE,
        m_ReservedResFileKey,
        0,
        fileData,
        TargetEndian);
}

bool BindTextureCommandBase::MakeCommandPacketImpl(nn::g3d::viewer::detail::CommandFlag commandFlag)
{
    List<UINT32>^ textureKeys = gcnew List<UINT32>();
    for each(IEditTarget^ texture in m_Textures)
    {
        if (texture->ResFileKey > 0)
        {
            textureKeys->Add(texture->ResFileKey);
        }
    }

    size_t packetSize = TextureCommandMaker::CalcTextureBindingPacketSize(textureKeys->ToArray());
    G3D_HTC_THROW_EXCEPTION_UNLESS(packetSize > 0, "Failed to calculate packet size");

    AllocPacketBuffer(static_cast<int>(packetSize));

    return TextureCommandMaker::MakeBindTexturesPacket(
        PacketBuffer,
        commandFlag,
        m_BindTargetKey,
        textureKeys->ToArray(),
        TargetEndian);
}

bool BindTextureCommand::MakeCommandPacket()
{
    return MakeCommandPacketImpl(nn::g3d::viewer::detail::TEXTURE_BIND_COMMAND_FLAG);
}

}}} // namespace NintendoWare.G3d.Edit
