﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "msclr/marshal.h"
#include "msclr/marshal_windows.h"
#include "msclr/marshal_cppstd.h"
#include "msclr/marshal_atl.h"

#include "AnimCommandMaker.h"
#include "SceneAnimCommandMaker.h"
#include "CommandUtility.h"
#include "Utility.h"
#include <nw/g3d/res/g3d_ResUtility.h>

using namespace System;
using namespace msclr::interop;
using namespace nw::g3d::edit::detail;

namespace NintendoWare { namespace G3d { namespace Edit {

bool SceneAnimCommandMaker::MakeBindSceneAnimationsPacket(
    array<Byte>^ packetBuffer,
    CommandFlag command,
    array<UINT32>^ animationKeys,
    TargetEndianKind endianKind)
{
    return AnimCommandMaker::MakeBindAnimationsPacket(
        packetBuffer,
        command,
        0,
        animationKeys,
        false,
        endianKind);
}

bool SceneAnimCommandMaker::MakeEditCameraAnimCurvePacket(
    array<Byte>^ packetBuffer,
    nw::g3d::tool::EditBinAnimCurve* animCurve,
    UINT32 animationKey,
    UINT32 cameraIndex,
    INT32 curveIndex,
    TargetEndianKind endianKind)
{
    return AnimCommandMaker::MakeEditAnimCurvePacket(
        packetBuffer,
        animCurve,
        SCENE_ANIMATION_EDIT_CURVE_COMMAND_FLAG,
        EDIT_TARGET_SCENE_ANIMATION_CAMERA_CURVE,
        animationKey,
        cameraIndex,
        curveIndex,
        endianKind);
}

bool SceneAnimCommandMaker::MakeEditLightAnimCurvePacket(
    array<Byte>^ packetBuffer,
    nw::g3d::tool::EditBinAnimCurve* animCurve,
    UINT32 animationKey,
    UINT32 lightIndex,
    INT32 curveIndex,
    TargetEndianKind endianKind)
{
    return AnimCommandMaker::MakeEditAnimCurvePacket(
        packetBuffer,
        animCurve,
        SCENE_ANIMATION_EDIT_CURVE_COMMAND_FLAG,
        EDIT_TARGET_SCENE_ANIMATION_LIGHT_CURVE,
        animationKey,
        lightIndex,
        curveIndex,
        endianKind);
}

bool SceneAnimCommandMaker::MakeEditFogAnimCurvePacket(
    array<Byte>^ packetBuffer,
    nw::g3d::tool::EditBinAnimCurve* animCurve,
    UINT32 animationKey,
    UINT32 fogIndex,
    INT32 curveIndex,
    TargetEndianKind endianKind)
{
    return AnimCommandMaker::MakeEditAnimCurvePacket(
        packetBuffer,
        animCurve,
        SCENE_ANIMATION_EDIT_CURVE_COMMAND_FLAG,
        EDIT_TARGET_SCENE_ANIMATION_FOG_CURVE,
        animationKey,
        fogIndex,
        curveIndex,
        endianKind);
}

}}} // namespace NintendoWare.G3d.Edit
