﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "RenderInfoCommand.h"
#include "RenderInfoCommandMaker.h"

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool QueryRenderInfoCommand::MakeCommandPacket()
{
    int packetSize = RenderInfoCommandMaker::CalcQueryRenderInfoPacketSize(Indices, m_RenderInfoList->ToArray());

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return RenderInfoCommandMaker::MakeQueryRenderInfoPacket(
        PacketBuffer,
        Target->ModelObjKey,
        Indices,
        m_RenderInfoList->ToArray(),
        TargetEndian);
}

bool EditStringRenderInfoCommand::MakeCommandPacket()
{
    int packetSize = RenderInfoCommandMaker::CalcSelectRenderInfoItemPacketSize(m_LabelName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return RenderInfoCommandMaker::MakeEditStringRenderInfoPacket(
        PacketBuffer,
        Target->ModelObjKey,
        m_MaterialIndex,
        m_LabelName,
        TargetEndian);
}

bool EditIntRenderInfoCommand::MakeCommandPacket()
{
    int packetSize = RenderInfoCommandMaker::CalcSelectRenderInfoItemPacketSize(m_LabelName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return RenderInfoCommandMaker::MakeEditIntRenderInfoPacket(
        PacketBuffer,
        Target->ModelObjKey,
        m_MaterialIndex,
        m_LabelName,
        m_SlotIndex,
        m_Value,
        TargetEndian);
}

bool EditFloatRenderInfoCommand::MakeCommandPacket()
{
    int packetSize = RenderInfoCommandMaker::CalcSelectRenderInfoItemPacketSize(m_LabelName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return RenderInfoCommandMaker::MakeEditFloatRenderInfoPacket(
        PacketBuffer,
        Target->ModelObjKey,
        m_MaterialIndex,
        m_LabelName,
        m_SlotIndex,
        m_Value,
        TargetEndian);
}

bool UpdateRenderInfoCommand::MakeCommandPacket()
{
    int packetSize = RenderInfoCommandMaker::CalcUpdateRenderInfoPacketSize(m_RenderInfoList->ToArray());

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return RenderInfoCommandMaker::MakeUpdateRenderInfoPacket(
        PacketBuffer,
        Target->ModelObjKey,
        m_MaterialIndex,
        m_RenderInfoList->ToArray(),
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
