﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "G3dHioLibDefs.h"

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class PreviewCommandMaker abstract sealed
{
public:
    static int CalcQueryModelLayoutPacketSize();
    static int CalcEditModelLayoutPacketSize();
    static int CalcEditBoneBindPacketSize();
    static int CalcEditShapeLodLevelPacketSize();

    static bool MakeQueryModelLayoutPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelObjKey,
        NintendoWare::G3d::Edit::TargetEndianKind endianKind);

    static bool MakeEditModelLayoutPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelObjKey,
        bool isBind,
        Math::Vector3^ scale,
        Math::Vector3^ rotate,
        Math::Vector3^ translate,
        NintendoWare::G3d::Edit::TargetEndianKind endianKind);

    static bool MakeEditBoneBindPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelObjKey,
        UINT32 parentModelObjKey,
        INT32 parentBoneIndex,
        NintendoWare::G3d::Edit::TargetEndianKind endianKind);

    static bool MakeEditShapeLodLevelPacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelObjKey,
        INT32 lodLevel,
        NintendoWare::G3d::Edit::TargetEndianKind endianKind);
};

}}} // namespace NintendoWare.G3d.Edit
