﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "PreviewCommand.h"
#include "PreviewCommandMaker.h"

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool QueryModelLayoutCommand::MakeCommandPacket()
{
    int packetSize = PreviewCommandMaker::CalcQueryModelLayoutPacketSize();

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return PreviewCommandMaker::MakeQueryModelLayoutPacket(
        PacketBuffer,
        Target->ModelObjKey,
        TargetEndian);
}

bool EditModelLayoutCommand::MakeCommandPacket()
{
    int packetSize = PreviewCommandMaker::CalcEditModelLayoutPacketSize();

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return PreviewCommandMaker::MakeEditModelLayoutPacket(
        PacketBuffer,
        Target->ModelObjKey,
        m_IsBind,
        m_Scale,
        m_Rotate,
        m_Translate,
        TargetEndian);
}

bool EditBoneBindCommand::MakeCommandPacket()
{
    int packetSize = PreviewCommandMaker::CalcEditBoneBindPacketSize();

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    UINT32 parentModelObjKey = 0;

    if (m_ParentModel != nullptr)
    {
        parentModelObjKey = m_ParentModel->ModelObjKey;
    }

    return PreviewCommandMaker::MakeEditBoneBindPacket(
        PacketBuffer,
        Target->ModelObjKey,
        parentModelObjKey,
        m_ParentBoneIndex,
        TargetEndian);
}

bool EditShapeLodLevelCommand::MakeCommandPacket()
{
    int packetSize = PreviewCommandMaker::CalcEditShapeLodLevelPacketSize();

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return PreviewCommandMaker::MakeEditShapeLodLevelPacket(
        PacketBuffer,
        Target->ModelObjKey,
        m_LodLevel,
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
