﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class SendAttachShaderDefineCommand : public EditShaderCommand
{
public:
    SendAttachShaderDefineCommand(TargetEndianKind targetEndian, IEditShaderArchiveTarget^ target)
        : EditShaderCommand(targetEndian, target)
    {
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }
};

private ref class UnloadShaderArchiveCommand : public EditShaderCommand
{
public:
    UnloadShaderArchiveCommand(TargetEndianKind targetEndian, IEditShaderArchiveTarget^ target)
        : EditShaderCommand(targetEndian, target)
    {
        m_ReservedShaderArchiveKey = target->ShaderArchiveKey;
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

    virtual void OnRemoved() override
    {
        Target->ResetStatus();
    }

protected:
    virtual bool CanProcessImpl() override
    {
        if (m_ReservedShaderArchiveKey > 0)
        {
            return true;
        }
        return false;
    }

private:
    UInt32 m_ReservedShaderArchiveKey;
};

private ref class ReloadShaderDefineCommand : public EditShaderCommand
{
public:
    ReloadShaderDefineCommand(TargetEndianKind targetEndian, IEditShaderArchiveTarget^ target, String^ fileName)
        : EditShaderCommand(targetEndian, target)
    {
        m_FileName = dynamic_cast<String^>(fileName->Clone());
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

private:
    String^ m_FileName;
};

private ref class ReloadShaderProgramCommand : public EditShaderCommand
{
public:
    ReloadShaderProgramCommand(TargetEndianKind targetEndian, IEditShaderArchiveTarget^ target, Int32 shadingModelIndex, Int32 shaderProgramIndex, String^ fileName)
        : EditShaderCommand(targetEndian, target)
    {
        m_FileName = dynamic_cast<String^>(fileName->Clone());
        m_ShadingModelIndex = shadingModelIndex;
        m_ShaderProgramIndex = shaderProgramIndex;
    }

    virtual bool MakeCommandPacket() override;

    virtual property bool IsInOrder
    {
        bool get() override
        {
            return true;
        }
    }

private:
    String^ m_FileName;
    INT32 m_ShadingModelIndex;
    INT32 m_ShaderProgramIndex;
};

}}} // namespace NintendoWare.G3d.Edit
