﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "LoadModelCommand.h"
#include "CommandMaker.h"

using namespace nw::g3d::edit::detail;

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool LoadModelCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(m_FileData->FileName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_LOAD_FILE_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_MODEL,
        Target->Key,
        0,
        m_FileData,
        TargetEndian);
}

bool ReloadModelCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(m_FileData->FileName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_RELOAD_FILE_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_MODEL,
        Target->ModelObjKey,
        0,
        m_FileData,
        TargetEndian);
}

bool UnloadModelCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(String::Empty);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    FileData^ fileData = gcnew FileData();
    fileData->Alignment = 0;
    fileData->FileName = String::Empty;

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_UNLOAD_FILE_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_MODEL,
        m_ReservedModelObjKey,
        0,
        fileData,
        TargetEndian);
}

bool SendAttachModelCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(m_FileData->FileName);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        EDIT_RECV_ATTACH_COMMAND_FLAG,
        nw::g3d::edit::detail::FILEDATA_MODEL,
        Target->ModelObjKey,
        0,
        m_FileData,
        TargetEndian);
}

bool UnloadAllCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcFileDataPacketSize(String::Empty);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    FileData^ fileData = gcnew FileData();
    fileData->Alignment = 0;
    fileData->FileName = String::Empty;

    return CommandMaker::MakeFileDataPacket(
        PacketBuffer,
        FILEDATA_UNLOAD_ALL_COMMAND_FLAG,
        FILEDATA_MODEL,
        0,
        0,
        fileData,
        TargetEndian);
}

bool LoadModelShaderArchiveCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcModelShaderArchivePacketSize(
        m_BfresFileData->FileName, m_FileNames->ToArray(), m_IsMaterialShaderInfos->ToArray());
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);
    return CommandMaker::MakeModelShaderArchivePacket(
        PacketBuffer,
        Target->ModelObjKey,
        m_BfresFileData,
        m_FileNames->ToArray(),
        m_IsMaterialShaderInfos->ToArray(),
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
