﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// g3dhiolib.h

#pragma once

#include "G3dHioLibDefs.h"
#include "MaterialShaderInfo.h"
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class CommandMaker abstract sealed
{
public:
    static int CalcSystemPacketSize();
    static int CalcFileDataPacketSize(System::String^ fileName);
    static int CalcEditValuePacketSize(array<INT32>^ indices);
    static int CalcModelShaderArchivePacketSize(
        System::String^ bfresFile, array<System::String^>^ fileNames, array<MaterialShaderInfo^>^ materialShaderIndices);

    static bool MakeSystemPacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::CommandFlag command,
        TargetEndianKind endianKind);

    static bool MakeFileDataPacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::CommandFlag command,
        nw::g3d::edit::detail::FileDataKind kind,
        UINT32 key,
        UINT32 resFileKey,
        FileData^ fileData,
        TargetEndianKind endianKind);

    static bool OverwriteModifiedShaderProgramPart(
        array<System::Byte>^ packetBuffer,
        INT32 shadingModelIndex,
        INT32 shaderProgramIndex,
        TargetEndianKind endianKind);

    generic<typename ValueType>
    static bool MakeEditValuePacket(
        array<System::Byte>^ packetBuffer,
        nw::g3d::edit::detail::CommandFlag command,
        nw::g3d::edit::detail::EditTargetKind editTargetKind,
        UINT32 key,
        array<INT32>^ indices,
        ValueType value,
        TargetEndianKind endianKind);

    static bool MakeModelShaderArchivePacket(
        array<System::Byte>^ packetBuffer,
        UINT32 modelObjKey,
        FileData^ bfresFileData,
        array<System::String^>^ fileNames,
        array<MaterialShaderInfo^>^ materialOptimizeInfos,
        TargetEndianKind endianKind);

private:
    static void MakeModelOptimizedShaderPacketImpl(
        array<System::Byte>^ packetBuffer,
        size_t totalSize,
        u32 modelObjKey,
        const std::vector<std::string>& convertFileNames,
        int materialCount,
        array<MaterialShaderInfo^>^ materialOptimizeInfos,
        int fileCount,
        const std::vector<u32>& fileSizeInfos,
        FileData^ bfresFileData,
        TargetEndianKind endianKind);
};

}}} // namespace NintendoWare.G3d.Edit
